using System;
using System.ComponentModel;
using System.Drawing;
using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using System.Windows.Forms;
using System.Collections;
using System.Text.RegularExpressions;

namespace gov.va.med.vbecs.GUI
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///UI Form allowing users to pool two or more units of platelets or cryo into a single pooled unit
		///</summary>

		#endregion

	public class FrmPoolUnits : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		/// <summary>
		/// BloodUnitModification Control object
		/// </summary>
		private BOL.BloodUnitModification _bumControl;

		/// <summary>
		/// Current Pooling Unit tab selected
		/// </summary>
		private BOL.BloodUnit _currentPoolingUnit;

		/// <summary>
		/// Is the form being populated with data via code -- (don't fire change events)
		/// </summary>
		private bool _isLoading;

		/// <summary>
		/// Corresponds to the list of products in the combbox -- this is an array of datarows (for Guid, ExpirationDateRule)
		/// </summary>
		private System.Collections.ArrayList _targetProductList;
		
		#endregion

		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Panel pnlTarget;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.Label lblMethod;
		private System.Windows.Forms.TextBox txtMethod;
		private System.Windows.Forms.TabControl tabPool;
		private System.Windows.Forms.TabPage pagePool;
		private System.Windows.Forms.GroupBox grpModificationDetails;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.TabControl tabOriginal;
		private System.Windows.Forms.TabPage pageOriginalUnit1;
		private System.Windows.Forms.TabPage pageOriginalUnit2;
		private System.Windows.Forms.Panel pnlOriginalUnit;
		private System.Windows.Forms.Panel pnlOriginalExtraInfo;
		private System.Windows.Forms.TabControl tabOriginalExtraInfo;
		private System.Windows.Forms.TabPage pageOriginalRestricted;
		private System.Windows.Forms.PictureBox picOriginalBiohazard;
		private System.Windows.Forms.TextBox txtOriginalRestrictedStatus;
		private System.Windows.Forms.Label lblOriginalRestrictedStatus;
		private System.Windows.Forms.TextBox txtOriginalRestrictedSSN;
		private System.Windows.Forms.TextBox txtOriginalRestrictedName;
		private System.Windows.Forms.Label lblOriginalRestrictedSSN;
		private System.Windows.Forms.Label lblOriginalRestrictedName;
		private System.Windows.Forms.TabPage pageOriginalAssigned;
		private System.Windows.Forms.TabPage pageOriginalSpecialTesting;
		private System.Windows.Forms.Label lblOriginalSickleCellNeg;
		private System.Windows.Forms.Label lblOriginalCMVNeg;
		private System.Windows.Forms.ListView lvOriginalAntigens;
		private System.Windows.Forms.Label lblOriginalRBCAntigens;
		private System.Windows.Forms.CheckBox cbOriginalSickleCellNeg;
		private System.Windows.Forms.CheckBox cbOriginalCMVNeg;
		private System.Windows.Forms.TextBox txtOriginalDonationType;
		private System.Windows.Forms.Label lblOriginalDonationType;
		private System.Windows.Forms.ColumnHeader colOriginalAntigen;
		private System.Windows.Forms.ColumnHeader colOriginalPosNeg;
		private System.Windows.Forms.Panel pnlOriginalUnitInfo;
		private System.Windows.Forms.TextBox txtOriginalUnitStatus;
		private System.Windows.Forms.Label lblOriginalUnitStatus;
		private System.Windows.Forms.TextBox txtOriginalProductName;
		private System.Windows.Forms.TextBox txtOriginalABORh;
		private System.Windows.Forms.TextBox txtOriginalUnitID;
		private System.Windows.Forms.Label lblOriginalProductName;
		private System.Windows.Forms.TextBox txtOriginalExpirationDate;
		private System.Windows.Forms.Label lblOriginalExpirationDate;
		private System.Windows.Forms.Label lblOriginalABORh;
		private System.Windows.Forms.Label lblOriginalUnitID;
		private System.Windows.Forms.ColumnHeader colTargetAntigens;
		private System.Windows.Forms.ColumnHeader colTargetPosNeg;
		private System.Windows.Forms.Panel pnlTargetUnit;
		private System.Windows.Forms.TabControl tabSuppliesEquipment;
		private System.Windows.Forms.TabPage pageContainer;
		private System.Windows.Forms.Button btnAddContainer;
		private System.Windows.Forms.ListView lvContainer;
		private System.Windows.Forms.TabPage pageSupplies;
		private System.Windows.Forms.Button btnAddSupplies;
		private System.Windows.Forms.ListView lvSupplies;
		private System.Windows.Forms.TabPage pageEquipment;
		private System.Windows.Forms.Button btnAddEquipment;
		private System.Windows.Forms.ListView lvEquipment;
		private System.Windows.Forms.TabPage pageSCDWafer;
		private System.Windows.Forms.Button btnAddWafer;
		private System.Windows.Forms.ListView lvSCDWafer;
		private System.Windows.Forms.Panel pnlTargetTop;
		private System.Windows.Forms.Panel pnlTargetExtraInfo;
		private System.Windows.Forms.TabControl tabTargetExtraInfo;
		private System.Windows.Forms.TabPage pageTargetRestricted;
		private System.Windows.Forms.PictureBox picTargetBiohazard;
		private System.Windows.Forms.TabPage pageTargetAssigned;
		private System.Windows.Forms.TabPage pageTargetSpecialTesting;
		private System.Windows.Forms.Label lblTargetSickleCellNeg;
		private System.Windows.Forms.Label lblTargetCMVNeg;
		private System.Windows.Forms.ListView lvTargetAntigens;
		private System.Windows.Forms.Label lblTargetRBCAntigens;
		private System.Windows.Forms.CheckBox cbTargetSickleCellNeg;
		private System.Windows.Forms.CheckBox cbTargetCMVNeg;
		private System.Windows.Forms.TextBox txtTargetDonationType;
		private System.Windows.Forms.Label lblTargetDonationType;
		private System.Windows.Forms.Panel pnlTargetUnitInfo;
		private System.Windows.Forms.TextBox txtTargetUnitStatus;
		private System.Windows.Forms.Label lblTargetUnitStatus;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbTargetProductName;
		private System.Windows.Forms.TextBox txtTargetABORh;
		private System.Windows.Forms.TextBox txtTargetUnitId;
		private System.Windows.Forms.DateTimePicker dtpTargetExpirationDate;
		private System.Windows.Forms.Label lblTargetProductName;
		private System.Windows.Forms.Label lblTargetExpirationDate;
		private System.Windows.Forms.Label lblTargetABORh;
		private System.Windows.Forms.Label lblTargetUnitId;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader colSupplyCheckbox;
		private System.Windows.Forms.ColumnHeader colSupplyLotNumber;
		private System.Windows.Forms.ColumnHeader colSupplyName;
		private System.Windows.Forms.ColumnHeader colSupplyManufacturer;
		private System.Windows.Forms.ColumnHeader colSupplyExpires;
		private System.Windows.Forms.ColumnHeader colEquipmentCheckbox;
		private System.Windows.Forms.ColumnHeader colSerialNumber;
		private System.Windows.Forms.ColumnHeader colEquipmentName;
		private System.Windows.Forms.ColumnHeader colEquipmentManufacturer;
		private System.Windows.Forms.ColumnHeader colLocalID;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.Label lblModifcationDate;
		private System.Windows.Forms.TextBox txtModificationDate;
		private System.Windows.Forms.RadioButton rdoIncomplete;
		private System.Windows.Forms.RadioButton rdoComplete;
		private System.Windows.Forms.Label lblOriginalVolume;
		private System.Windows.Forms.TextBox txtOriginalVolume;
		private System.Windows.Forms.Label lblNumberOfUnits;
		private System.Windows.Forms.TextBox txtNumberOfUnits;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ListView lvOrginalAssigned;
		private System.Windows.Forms.TextBox txtTargetRestrictedName;
		private System.Windows.Forms.TextBox txtTargetRestrictedSSN;
		private System.Windows.Forms.TextBox txtTargetRestrictedStatus;
		private System.Windows.Forms.Label lblTargetTestingStatus;
		private System.Windows.Forms.Label lblTargetRestrictedSSN;
		private System.Windows.Forms.Label lblTargetRestrictedName;
		private System.Windows.Forms.ListView lvTargetAssigned;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ColumnHeader columnHeader15;
		private System.Windows.Forms.ColumnHeader columnHeader16;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.GroupBox grpWeld;
		private System.Windows.Forms.GroupBox grpPool;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updTargetVolume;
		private System.Windows.Forms.Label lblTargetVolume;
		private System.ComponentModel.IContainer components = null;
		#endregion

		#region Constructors/Destructors

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmPoolUnits(BOL.BloodUnitModification modifyControl)
		{
			this.LockController.LockFunction = Common.LockFunctions.UC024PoolUnits;

			this._isLoading = true;

			//Chaned =07/20/2005 - need FormInstanceGuid to set locking in, now that SetLocks has been called, we're gold
			//PoolUnits Method will create the PooledUnit object where we can grab the guids
            //LOCKING420 - Scrapping FormInstanceGuid for more robust LockController
			modifyControl.PoolUnits(this.LockController);

			bool processAssignments = modifyControl.DoPoolingUnitsHaveAssignedPatients;

			foreach (BOL.BloodUnit poolingUnit in modifyControl.PoolingUnits)
			{
				//Need BloodUnitStatus Guid = because label verification failure will quarantine the unit
				this.LockController.RecordGuids.Add(poolingUnit.BloodUnitStatus.BloodUnitStatusGuid);

				if (processAssignments)
				{
					foreach(BOL.Patient tmpPatient in poolingUnit.AssignedToPatients)
					{
						BOL.OrderedUnit tmpOU = new BOL.OrderedUnit(poolingUnit.BloodUnitGuid, tmpPatient.PatientGuid);
						this.LockController.RecordGuids.Add(tmpOU.OrderedUnitGuid);
					}
				}
			}

			//Everything about a Pooled unit can change when editing
			if (modifyControl.ProductModificationCode == Common.ProductModification.EditPool)
			{
				this.LockController.RecordGuids.Add(modifyControl.PooledUnit.NewUnit.BloodUnitGuid);
				this.LockController.RecordGuids.Add(modifyControl.PooledUnit.NewUnit.BloodUnitFinance.BloodUnitFinanceGuid);
				this.LockController.RecordGuids.Add(modifyControl.PooledUnit.NewUnit.BloodUnitMedia.BloodUnitMediaGuid);
				this.LockController.RecordGuids.Add(modifyControl.PooledUnit.NewUnit.BloodUnitStatus.BloodUnitStatusGuid);

				//Lock the pooledUnit's OrderedUnits' too, since label verfication failure will release
				foreach(BOL.Patient tmpPatient in modifyControl.PooledUnit.NewUnit.AssignedToPatients)
				{
					BOL.OrderedUnit tmpOU = new BOL.OrderedUnit(modifyControl.PooledUnit.NewUnit.BloodUnitGuid, tmpPatient.PatientGuid);
					this.LockController.RecordGuids.Add(tmpOU.OrderedUnitGuid);
				}
			}
	
			if (!this.SetLocks())
			{
				//We need to specifically call UnlockAllRecords here, (unlike other use cases)
				//because of the control code put in PoolUnits(), which creates a lock on the PoolCounter
				//table to make sure that we grab the next sequential pool number.
				this.UnlockAllRecords();
				this.DialogResult = DialogResult.Abort;
				//CR 3035 Removed the line of code causing crash when record is locked
				return;
			}
			//-------------------
			
			InitializeComponent();

			this._bumControl = modifyControl;
			
			this.SetComponentProperties();			
			this.CreateParentTabs();

			this._currentPoolingUnit = (BOL.BloodUnit)this._bumControl.PoolingUnits[this.tabOriginal.SelectedIndex];

			this.PopulateSourceDetails();				
			this.PopulateTargetDetails();

			//IF we're an Edit -- the WeldIndicator may already be selected
			if (this._bumControl.ProductModificationCode == Common.ProductModification.EditPool)
			{
				rdoComplete.Checked = this._bumControl.PooledUnit.WeldIndicator;
				rdoIncomplete.Checked = this._bumControl.PooledUnit.WeldIndicator;
				rdoComplete.Enabled = false;
				rdoIncomplete.Enabled = false;
			}

			//The WeldCompletenessIndicator has TabIndex = 0, which will automatically select
			//on form load.  This will prevent that, and force user selection.
			if (this._bumControl.ModificationMethod == Common.ModifyUnitMethod.SterileConnectingDevice)
			{
				this.btnCancel.TabIndex = 0;
			}

			this._isLoading = false;

			//Set the broken rules
			this._bumControl.SetInitialBrokenRules(this.Name, string.Empty);

			//Attach our events
			this._bumControl.Invalid += new EventHandler(this.ObjectValidityChange);
			this._bumControl.Valid += new EventHandler(this.ObjectValidityChange);
			this._bumControl.ModifiedUnitStateChange += new EventHandler(this.ObjectValidityChange);
			this._bumControl.WeldIndicatorChanged += new EventHandler(this.RefreshExpirationDate);



			//This fires off just to make sure the OK button is enabled properly with the right text
			this.ObjectValidityChange(this,System.EventArgs.Empty);
			this.txtNumberOfUnits.Focus();
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmPoolUnits));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.pnlTarget = new System.Windows.Forms.Panel();
			this.panel1 = new System.Windows.Forms.Panel();
			this.grpModificationDetails = new System.Windows.Forms.GroupBox();
			this.lblMethod = new System.Windows.Forms.Label();
			this.lblModifcationDate = new System.Windows.Forms.Label();
			this.txtMethod = new System.Windows.Forms.TextBox();
			this.txtModificationDate = new System.Windows.Forms.TextBox();
			this.grpPool = new System.Windows.Forms.GroupBox();
			this.txtNumberOfUnits = new System.Windows.Forms.TextBox();
			this.lblNumberOfUnits = new System.Windows.Forms.Label();
			this.grpWeld = new System.Windows.Forms.GroupBox();
			this.rdoComplete = new System.Windows.Forms.RadioButton();
			this.rdoIncomplete = new System.Windows.Forms.RadioButton();
			this.pnlOriginalUnit = new System.Windows.Forms.Panel();
			this.pnlOriginalExtraInfo = new System.Windows.Forms.Panel();
			this.tabOriginalExtraInfo = new System.Windows.Forms.TabControl();
			this.pageOriginalRestricted = new System.Windows.Forms.TabPage();
			this.picOriginalBiohazard = new System.Windows.Forms.PictureBox();
			this.txtOriginalRestrictedStatus = new System.Windows.Forms.TextBox();
			this.lblOriginalRestrictedStatus = new System.Windows.Forms.Label();
			this.txtOriginalRestrictedSSN = new System.Windows.Forms.TextBox();
			this.txtOriginalRestrictedName = new System.Windows.Forms.TextBox();
			this.lblOriginalRestrictedSSN = new System.Windows.Forms.Label();
			this.lblOriginalRestrictedName = new System.Windows.Forms.Label();
			this.pageOriginalAssigned = new System.Windows.Forms.TabPage();
			this.lvOrginalAssigned = new System.Windows.Forms.ListView();
			this.columnHeader9 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader10 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader11 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader12 = new System.Windows.Forms.ColumnHeader();
			this.pageOriginalSpecialTesting = new System.Windows.Forms.TabPage();
			this.lblOriginalSickleCellNeg = new System.Windows.Forms.Label();
			this.lblOriginalCMVNeg = new System.Windows.Forms.Label();
			this.lvOriginalAntigens = new System.Windows.Forms.ListView();
			this.colOriginalAntigen = new System.Windows.Forms.ColumnHeader();
			this.colOriginalPosNeg = new System.Windows.Forms.ColumnHeader();
			this.lblOriginalRBCAntigens = new System.Windows.Forms.Label();
			this.cbOriginalSickleCellNeg = new System.Windows.Forms.CheckBox();
			this.cbOriginalCMVNeg = new System.Windows.Forms.CheckBox();
			this.txtOriginalDonationType = new System.Windows.Forms.TextBox();
			this.lblOriginalDonationType = new System.Windows.Forms.Label();
			this.pnlOriginalUnitInfo = new System.Windows.Forms.Panel();
			this.txtOriginalVolume = new System.Windows.Forms.TextBox();
			this.lblOriginalVolume = new System.Windows.Forms.Label();
			this.txtOriginalUnitStatus = new System.Windows.Forms.TextBox();
			this.lblOriginalUnitStatus = new System.Windows.Forms.Label();
			this.txtOriginalProductName = new System.Windows.Forms.TextBox();
			this.txtOriginalABORh = new System.Windows.Forms.TextBox();
			this.txtOriginalUnitID = new System.Windows.Forms.TextBox();
			this.lblOriginalProductName = new System.Windows.Forms.Label();
			this.txtOriginalExpirationDate = new System.Windows.Forms.TextBox();
			this.lblOriginalExpirationDate = new System.Windows.Forms.Label();
			this.lblOriginalABORh = new System.Windows.Forms.Label();
			this.lblOriginalUnitID = new System.Windows.Forms.Label();
			this.tabPool = new System.Windows.Forms.TabControl();
			this.pagePool = new System.Windows.Forms.TabPage();
			this.pnlTargetUnit = new System.Windows.Forms.Panel();
			this.tabSuppliesEquipment = new System.Windows.Forms.TabControl();
			this.pageContainer = new System.Windows.Forms.TabPage();
			this.btnAddContainer = new System.Windows.Forms.Button();
			this.lvContainer = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.pageSupplies = new System.Windows.Forms.TabPage();
			this.btnAddSupplies = new System.Windows.Forms.Button();
			this.lvSupplies = new System.Windows.Forms.ListView();
			this.colSupplyCheckbox = new System.Windows.Forms.ColumnHeader();
			this.colSupplyLotNumber = new System.Windows.Forms.ColumnHeader();
			this.colSupplyName = new System.Windows.Forms.ColumnHeader();
			this.colSupplyManufacturer = new System.Windows.Forms.ColumnHeader();
			this.colSupplyExpires = new System.Windows.Forms.ColumnHeader();
			this.pageEquipment = new System.Windows.Forms.TabPage();
			this.btnAddEquipment = new System.Windows.Forms.Button();
			this.lvEquipment = new System.Windows.Forms.ListView();
			this.colEquipmentCheckbox = new System.Windows.Forms.ColumnHeader();
			this.colSerialNumber = new System.Windows.Forms.ColumnHeader();
			this.colEquipmentName = new System.Windows.Forms.ColumnHeader();
			this.colEquipmentManufacturer = new System.Windows.Forms.ColumnHeader();
			this.colLocalID = new System.Windows.Forms.ColumnHeader();
			this.pageSCDWafer = new System.Windows.Forms.TabPage();
			this.btnAddWafer = new System.Windows.Forms.Button();
			this.lvSCDWafer = new System.Windows.Forms.ListView();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader8 = new System.Windows.Forms.ColumnHeader();
			this.pnlTargetTop = new System.Windows.Forms.Panel();
			this.pnlTargetExtraInfo = new System.Windows.Forms.Panel();
			this.tabTargetExtraInfo = new System.Windows.Forms.TabControl();
			this.pageTargetRestricted = new System.Windows.Forms.TabPage();
			this.picTargetBiohazard = new System.Windows.Forms.PictureBox();
			this.txtTargetRestrictedStatus = new System.Windows.Forms.TextBox();
			this.lblTargetTestingStatus = new System.Windows.Forms.Label();
			this.txtTargetRestrictedSSN = new System.Windows.Forms.TextBox();
			this.txtTargetRestrictedName = new System.Windows.Forms.TextBox();
			this.lblTargetRestrictedSSN = new System.Windows.Forms.Label();
			this.lblTargetRestrictedName = new System.Windows.Forms.Label();
			this.pageTargetAssigned = new System.Windows.Forms.TabPage();
			this.lvTargetAssigned = new System.Windows.Forms.ListView();
			this.columnHeader13 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader14 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader15 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader16 = new System.Windows.Forms.ColumnHeader();
			this.pageTargetSpecialTesting = new System.Windows.Forms.TabPage();
			this.lblTargetSickleCellNeg = new System.Windows.Forms.Label();
			this.lblTargetCMVNeg = new System.Windows.Forms.Label();
			this.lvTargetAntigens = new System.Windows.Forms.ListView();
			this.colTargetAntigens = new System.Windows.Forms.ColumnHeader();
			this.colTargetPosNeg = new System.Windows.Forms.ColumnHeader();
			this.lblTargetRBCAntigens = new System.Windows.Forms.Label();
			this.cbTargetSickleCellNeg = new System.Windows.Forms.CheckBox();
			this.cbTargetCMVNeg = new System.Windows.Forms.CheckBox();
			this.txtTargetDonationType = new System.Windows.Forms.TextBox();
			this.lblTargetDonationType = new System.Windows.Forms.Label();
			this.pnlTargetUnitInfo = new System.Windows.Forms.Panel();
			this.dtpTargetExpirationDate = new System.Windows.Forms.DateTimePicker();
			this.updTargetVolume = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblTargetVolume = new System.Windows.Forms.Label();
			this.txtTargetUnitStatus = new System.Windows.Forms.TextBox();
			this.lblTargetUnitStatus = new System.Windows.Forms.Label();
			this.cmbTargetProductName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.txtTargetABORh = new System.Windows.Forms.TextBox();
			this.txtTargetUnitId = new System.Windows.Forms.TextBox();
			this.lblTargetProductName = new System.Windows.Forms.Label();
			this.lblTargetExpirationDate = new System.Windows.Forms.Label();
			this.lblTargetABORh = new System.Windows.Forms.Label();
			this.lblTargetUnitId = new System.Windows.Forms.Label();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.tabOriginal = new System.Windows.Forms.TabControl();
			this.pageOriginalUnit1 = new System.Windows.Forms.TabPage();
			this.pageOriginalUnit2 = new System.Windows.Forms.TabPage();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.pnlTarget.SuspendLayout();
			this.panel1.SuspendLayout();
			this.grpModificationDetails.SuspendLayout();
			this.grpPool.SuspendLayout();
			this.grpWeld.SuspendLayout();
			this.pnlOriginalUnit.SuspendLayout();
			this.pnlOriginalExtraInfo.SuspendLayout();
			this.tabOriginalExtraInfo.SuspendLayout();
			this.pageOriginalRestricted.SuspendLayout();
			this.pageOriginalAssigned.SuspendLayout();
			this.pageOriginalSpecialTesting.SuspendLayout();
			this.pnlOriginalUnitInfo.SuspendLayout();
			this.tabPool.SuspendLayout();
			this.pagePool.SuspendLayout();
			this.pnlTargetUnit.SuspendLayout();
			this.tabSuppliesEquipment.SuspendLayout();
			this.pageContainer.SuspendLayout();
			this.pageSupplies.SuspendLayout();
			this.pageEquipment.SuspendLayout();
			this.pageSCDWafer.SuspendLayout();
			this.pnlTargetTop.SuspendLayout();
			this.pnlTargetExtraInfo.SuspendLayout();
			this.tabTargetExtraInfo.SuspendLayout();
			this.pageTargetRestricted.SuspendLayout();
			this.pageTargetAssigned.SuspendLayout();
			this.pageTargetSpecialTesting.SuspendLayout();
			this.pnlTargetUnitInfo.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updTargetVolume)).BeginInit();
			this.groupBox1.SuspendLayout();
			this.tabOriginal.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(624, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 507);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(464, 500);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 45;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(544, 500);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 46;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// pnlTarget
			// 
			this.pnlTarget.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlTarget.Controls.Add(this.panel1);
			this.pnlTarget.Controls.Add(this.pnlOriginalUnit);
			this.pnlTarget.Controls.Add(this.tabPool);
			this.pnlTarget.Controls.Add(this.groupBox1);
			this.pnlTarget.Controls.Add(this.tabOriginal);
			this.pnlTarget.Location = new System.Drawing.Point(0, 32);
			this.pnlTarget.Name = "pnlTarget";
			this.pnlTarget.Size = new System.Drawing.Size(624, 464);
			this.pnlTarget.TabIndex = 20;
			// 
			// panel1
			// 
			this.panel1.Controls.Add(this.grpModificationDetails);
			this.panel1.Controls.Add(this.grpPool);
			this.panel1.Controls.Add(this.grpWeld);
			this.panel1.Location = new System.Drawing.Point(4, 0);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(616, 60);
			this.panel1.TabIndex = 0;
			// 
			// grpModificationDetails
			// 
			this.grpModificationDetails.AccessibleDescription = "Modification ";
			this.grpModificationDetails.AccessibleName = "Modification ";
			this.grpModificationDetails.Controls.Add(this.lblMethod);
			this.grpModificationDetails.Controls.Add(this.lblModifcationDate);
			this.grpModificationDetails.Controls.Add(this.txtMethod);
			this.grpModificationDetails.Controls.Add(this.txtModificationDate);
			this.grpModificationDetails.Dock = System.Windows.Forms.DockStyle.Fill;
			this.grpModificationDetails.Location = new System.Drawing.Point(180, 0);
			this.grpModificationDetails.Name = "grpModificationDetails";
			this.grpModificationDetails.Size = new System.Drawing.Size(308, 60);
			this.grpModificationDetails.TabIndex = 1;
			this.grpModificationDetails.TabStop = false;
			this.grpModificationDetails.Text = "Modification";
			// 
			// lblMethod
			// 
			this.lblMethod.Location = new System.Drawing.Point(8, 16);
			this.lblMethod.Name = "lblMethod";
			this.lblMethod.Size = new System.Drawing.Size(56, 16);
			this.lblMethod.TabIndex = 77;
			this.lblMethod.Text = "Method";
			this.lblMethod.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblModifcationDate
			// 
			this.lblModifcationDate.Location = new System.Drawing.Point(8, 36);
			this.lblModifcationDate.Name = "lblModifcationDate";
			this.lblModifcationDate.Size = new System.Drawing.Size(92, 20);
			this.lblModifcationDate.TabIndex = 76;
			this.lblModifcationDate.Text = "Modification Date";
			this.lblModifcationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtMethod
			// 
			this.txtMethod.AccessibleDescription = "Method ";
			this.txtMethod.AccessibleName = "Method ";
			this.txtMethod.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtMethod.Location = new System.Drawing.Point(100, 12);
			this.txtMethod.Name = "txtMethod";
			this.txtMethod.ReadOnly = true;
			this.txtMethod.Size = new System.Drawing.Size(200, 20);
			this.txtMethod.TabIndex = 1;
			this.txtMethod.Text = "";
			// 
			// txtModificationDate
			// 
			this.txtModificationDate.AccessibleDescription = "Modifcation Date";
			this.txtModificationDate.AccessibleName = "Modifcation Date";
			this.txtModificationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtModificationDate.Location = new System.Drawing.Point(100, 36);
			this.txtModificationDate.Name = "txtModificationDate";
			this.txtModificationDate.ReadOnly = true;
			this.txtModificationDate.Size = new System.Drawing.Size(200, 20);
			this.txtModificationDate.TabIndex = 2;
			this.txtModificationDate.Text = "";
			// 
			// grpPool
			// 
			this.grpPool.AccessibleDescription = "Pool";
			this.grpPool.AccessibleName = "Pool";
			this.grpPool.Controls.Add(this.txtNumberOfUnits);
			this.grpPool.Controls.Add(this.lblNumberOfUnits);
			this.grpPool.Dock = System.Windows.Forms.DockStyle.Left;
			this.grpPool.Location = new System.Drawing.Point(0, 0);
			this.grpPool.Name = "grpPool";
			this.grpPool.Size = new System.Drawing.Size(180, 60);
			this.grpPool.TabIndex = 0;
			this.grpPool.TabStop = false;
			this.grpPool.Text = "Pool";
			// 
			// txtNumberOfUnits
			// 
			this.txtNumberOfUnits.AccessibleDescription = "Number of Pooled Units";
			this.txtNumberOfUnits.AccessibleName = "Number of Pooled Units";
			this.txtNumberOfUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtNumberOfUnits.Location = new System.Drawing.Point(124, 16);
			this.txtNumberOfUnits.Name = "txtNumberOfUnits";
			this.txtNumberOfUnits.ReadOnly = true;
			this.txtNumberOfUnits.Size = new System.Drawing.Size(48, 20);
			this.txtNumberOfUnits.TabIndex = 0;
			this.txtNumberOfUnits.Text = "";
			// 
			// lblNumberOfUnits
			// 
			this.lblNumberOfUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblNumberOfUnits.Location = new System.Drawing.Point(8, 16);
			this.lblNumberOfUnits.Name = "lblNumberOfUnits";
			this.lblNumberOfUnits.Size = new System.Drawing.Size(124, 20);
			this.lblNumberOfUnits.TabIndex = 87;
			this.lblNumberOfUnits.Text = "Number of Pooled Units";
			this.lblNumberOfUnits.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpWeld
			// 
			this.grpWeld.AccessibleDescription = "Weld";
			this.grpWeld.AccessibleName = "Weld";
			this.grpWeld.Controls.Add(this.rdoComplete);
			this.grpWeld.Controls.Add(this.rdoIncomplete);
			this.grpWeld.Dock = System.Windows.Forms.DockStyle.Right;
			this.grpWeld.Location = new System.Drawing.Point(488, 0);
			this.grpWeld.Name = "grpWeld";
			this.grpWeld.Size = new System.Drawing.Size(128, 60);
			this.grpWeld.TabIndex = 3;
			this.grpWeld.TabStop = false;
			this.grpWeld.Text = "Weld*";
			// 
			// rdoComplete
			// 
			this.rdoComplete.AccessibleDescription = "Weld Complete";
			this.rdoComplete.AccessibleName = "Weld Complete";
			this.rdoComplete.Location = new System.Drawing.Point(8, 16);
			this.rdoComplete.Name = "rdoComplete";
			this.rdoComplete.Size = new System.Drawing.Size(108, 16);
			this.rdoComplete.TabIndex = 3;
			this.rdoComplete.TabStop = true;
			this.rdoComplete.Text = "Wel&d Complete";
			this.rdoComplete.CheckedChanged += new System.EventHandler(this.rdoComplete_CheckedChanged);
			// 
			// rdoIncomplete
			// 
			this.rdoIncomplete.AccessibleDescription = "Weld Incomplete";
			this.rdoIncomplete.AccessibleName = "Weld Incomplete";
			this.rdoIncomplete.Location = new System.Drawing.Point(8, 36);
			this.rdoIncomplete.Name = "rdoIncomplete";
			this.rdoIncomplete.Size = new System.Drawing.Size(108, 16);
			this.rdoIncomplete.TabIndex = 3;
			this.rdoIncomplete.Text = "Weld &Incomplete";
			this.rdoIncomplete.CheckedChanged += new System.EventHandler(this.rdoIncomplete_CheckedChanged);
			// 
			// pnlOriginalUnit
			// 
			this.pnlOriginalUnit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlOriginalUnit.Controls.Add(this.pnlOriginalExtraInfo);
			this.pnlOriginalUnit.Controls.Add(this.pnlOriginalUnitInfo);
			this.pnlOriginalUnit.Location = new System.Drawing.Point(60, 87);
			this.pnlOriginalUnit.Name = "pnlOriginalUnit";
			this.pnlOriginalUnit.Size = new System.Drawing.Size(560, 126);
			this.pnlOriginalUnit.TabIndex = 4;
			// 
			// pnlOriginalExtraInfo
			// 
			this.pnlOriginalExtraInfo.Controls.Add(this.tabOriginalExtraInfo);
			this.pnlOriginalExtraInfo.Controls.Add(this.txtOriginalDonationType);
			this.pnlOriginalExtraInfo.Controls.Add(this.lblOriginalDonationType);
			this.pnlOriginalExtraInfo.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlOriginalExtraInfo.Location = new System.Drawing.Point(300, 0);
			this.pnlOriginalExtraInfo.Name = "pnlOriginalExtraInfo";
			this.pnlOriginalExtraInfo.Size = new System.Drawing.Size(260, 126);
			this.pnlOriginalExtraInfo.TabIndex = 11;
			// 
			// tabOriginalExtraInfo
			// 
			this.tabOriginalExtraInfo.Alignment = System.Windows.Forms.TabAlignment.Bottom;
			this.tabOriginalExtraInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabOriginalExtraInfo.Controls.Add(this.pageOriginalRestricted);
			this.tabOriginalExtraInfo.Controls.Add(this.pageOriginalAssigned);
			this.tabOriginalExtraInfo.Controls.Add(this.pageOriginalSpecialTesting);
			this.tabOriginalExtraInfo.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tabOriginalExtraInfo.Location = new System.Drawing.Point(4, 24);
			this.tabOriginalExtraInfo.Name = "tabOriginalExtraInfo";
			this.tabOriginalExtraInfo.SelectedIndex = 0;
			this.tabOriginalExtraInfo.Size = new System.Drawing.Size(252, 98);
			this.tabOriginalExtraInfo.TabIndex = 12;
			this.tabOriginalExtraInfo.SelectedIndexChanged += new System.EventHandler(this.ExtraInfoTabsClicked);
			// 
			// pageOriginalRestricted
			// 
			this.pageOriginalRestricted.Controls.Add(this.picOriginalBiohazard);
			this.pageOriginalRestricted.Controls.Add(this.txtOriginalRestrictedStatus);
			this.pageOriginalRestricted.Controls.Add(this.lblOriginalRestrictedStatus);
			this.pageOriginalRestricted.Controls.Add(this.txtOriginalRestrictedSSN);
			this.pageOriginalRestricted.Controls.Add(this.txtOriginalRestrictedName);
			this.pageOriginalRestricted.Controls.Add(this.lblOriginalRestrictedSSN);
			this.pageOriginalRestricted.Controls.Add(this.lblOriginalRestrictedName);
			this.pageOriginalRestricted.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageOriginalRestricted.Location = new System.Drawing.Point(4, 4);
			this.pageOriginalRestricted.Name = "pageOriginalRestricted";
			this.pageOriginalRestricted.Size = new System.Drawing.Size(244, 73);
			this.pageOriginalRestricted.TabIndex = 0;
			this.pageOriginalRestricted.Text = "Restricted For";
			// 
			// picOriginalBiohazard
			// 
			this.picOriginalBiohazard.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.picOriginalBiohazard.Image = ((System.Drawing.Image)(resources.GetObject("picOriginalBiohazard.Image")));
			this.picOriginalBiohazard.Location = new System.Drawing.Point(216, 40);
			this.picOriginalBiohazard.Name = "picOriginalBiohazard";
			this.picOriginalBiohazard.Size = new System.Drawing.Size(26, 28);
			this.picOriginalBiohazard.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picOriginalBiohazard.TabIndex = 34;
			this.picOriginalBiohazard.TabStop = false;
			this.picOriginalBiohazard.Visible = false;
			// 
			// txtOriginalRestrictedStatus
			// 
			this.txtOriginalRestrictedStatus.AccessibleDescription = "Disease Marker Testing";
			this.txtOriginalRestrictedStatus.AccessibleName = "Disease Marker Testing";
			this.txtOriginalRestrictedStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalRestrictedStatus.Location = new System.Drawing.Point(88, 48);
			this.txtOriginalRestrictedStatus.Name = "txtOriginalRestrictedStatus";
			this.txtOriginalRestrictedStatus.ReadOnly = true;
			this.txtOriginalRestrictedStatus.Size = new System.Drawing.Size(124, 20);
			this.txtOriginalRestrictedStatus.TabIndex = 15;
			this.txtOriginalRestrictedStatus.Text = "";
			// 
			// lblOriginalRestrictedStatus
			// 
			this.lblOriginalRestrictedStatus.Location = new System.Drawing.Point(0, 48);
			this.lblOriginalRestrictedStatus.Name = "lblOriginalRestrictedStatus";
			this.lblOriginalRestrictedStatus.Size = new System.Drawing.Size(92, 24);
			this.lblOriginalRestrictedStatus.TabIndex = 15;
			this.lblOriginalRestrictedStatus.Text = "Disease Marker Testing";
			this.lblOriginalRestrictedStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOriginalRestrictedSSN
			// 
			this.txtOriginalRestrictedSSN.AccessibleDescription = "Patient I D";
			this.txtOriginalRestrictedSSN.AccessibleName = "Patient I D";
			this.txtOriginalRestrictedSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalRestrictedSSN.Location = new System.Drawing.Point(88, 24);
			this.txtOriginalRestrictedSSN.Name = "txtOriginalRestrictedSSN";
			this.txtOriginalRestrictedSSN.ReadOnly = true;
			this.txtOriginalRestrictedSSN.Size = new System.Drawing.Size(124, 20);
			this.txtOriginalRestrictedSSN.TabIndex = 14;
			this.txtOriginalRestrictedSSN.Text = "";
			// 
			// txtOriginalRestrictedName
			// 
			this.txtOriginalRestrictedName.AccessibleDescription = "Patient Name";
			this.txtOriginalRestrictedName.AccessibleName = "Patient Name";
			this.txtOriginalRestrictedName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalRestrictedName.Location = new System.Drawing.Point(88, 0);
			this.txtOriginalRestrictedName.Name = "txtOriginalRestrictedName";
			this.txtOriginalRestrictedName.ReadOnly = true;
			this.txtOriginalRestrictedName.Size = new System.Drawing.Size(156, 20);
			this.txtOriginalRestrictedName.TabIndex = 13;
			this.txtOriginalRestrictedName.Text = "";
			// 
			// lblOriginalRestrictedSSN
			// 
			this.lblOriginalRestrictedSSN.Location = new System.Drawing.Point(0, 24);
			this.lblOriginalRestrictedSSN.Name = "lblOriginalRestrictedSSN";
			this.lblOriginalRestrictedSSN.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalRestrictedSSN.TabIndex = 12;
			this.lblOriginalRestrictedSSN.Text = "Patient ID";
			this.lblOriginalRestrictedSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblOriginalRestrictedName
			// 
			this.lblOriginalRestrictedName.Location = new System.Drawing.Point(0, 0);
			this.lblOriginalRestrictedName.Name = "lblOriginalRestrictedName";
			this.lblOriginalRestrictedName.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalRestrictedName.TabIndex = 11;
			this.lblOriginalRestrictedName.Text = "Patient Name";
			this.lblOriginalRestrictedName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pageOriginalAssigned
			// 
			this.pageOriginalAssigned.Controls.Add(this.lvOrginalAssigned);
			this.pageOriginalAssigned.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageOriginalAssigned.Location = new System.Drawing.Point(4, 4);
			this.pageOriginalAssigned.Name = "pageOriginalAssigned";
			this.pageOriginalAssigned.Size = new System.Drawing.Size(244, 73);
			this.pageOriginalAssigned.TabIndex = 1;
			this.pageOriginalAssigned.Text = "Assigned To";
			this.pageOriginalAssigned.Visible = false;
			// 
			// lvOrginalAssigned
			// 
			this.lvOrginalAssigned.AccessibleDescription = "Assigned To";
			this.lvOrginalAssigned.AccessibleName = "Assigned To";
			this.lvOrginalAssigned.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvOrginalAssigned.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								this.columnHeader9,
																								this.columnHeader10,
																								this.columnHeader11,
																								this.columnHeader12});
			this.lvOrginalAssigned.Location = new System.Drawing.Point(0, 0);
			this.lvOrginalAssigned.Name = "lvOrginalAssigned";
			this.lvOrginalAssigned.Size = new System.Drawing.Size(244, 72);
			this.lvOrginalAssigned.TabIndex = 16;
			this.lvOrginalAssigned.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader9
			// 
			this.columnHeader9.Text = "Patient Name";
			this.columnHeader9.Width = 80;
			// 
			// columnHeader10
			// 
			this.columnHeader10.Text = "Patient ID";
			// 
			// columnHeader11
			// 
			this.columnHeader11.Text = "Specimen UID";
			this.columnHeader11.Width = 80;
			// 
			// columnHeader12
			// 
			this.columnHeader12.Text = "Specimen Expires";
			this.columnHeader12.Width = 100;
			// 
			// pageOriginalSpecialTesting
			// 
			this.pageOriginalSpecialTesting.Controls.Add(this.lblOriginalSickleCellNeg);
			this.pageOriginalSpecialTesting.Controls.Add(this.lblOriginalCMVNeg);
			this.pageOriginalSpecialTesting.Controls.Add(this.lvOriginalAntigens);
			this.pageOriginalSpecialTesting.Controls.Add(this.lblOriginalRBCAntigens);
			this.pageOriginalSpecialTesting.Controls.Add(this.cbOriginalSickleCellNeg);
			this.pageOriginalSpecialTesting.Controls.Add(this.cbOriginalCMVNeg);
			this.pageOriginalSpecialTesting.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageOriginalSpecialTesting.Location = new System.Drawing.Point(4, 4);
			this.pageOriginalSpecialTesting.Name = "pageOriginalSpecialTesting";
			this.pageOriginalSpecialTesting.Size = new System.Drawing.Size(244, 73);
			this.pageOriginalSpecialTesting.TabIndex = 2;
			this.pageOriginalSpecialTesting.Text = "Special Testing";
			this.pageOriginalSpecialTesting.Visible = false;
			// 
			// lblOriginalSickleCellNeg
			// 
			this.lblOriginalSickleCellNeg.Location = new System.Drawing.Point(0, 40);
			this.lblOriginalSickleCellNeg.Name = "lblOriginalSickleCellNeg";
			this.lblOriginalSickleCellNeg.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalSickleCellNeg.TabIndex = 17;
			this.lblOriginalSickleCellNeg.Text = "Sickle Cell &Neg?";
			this.lblOriginalSickleCellNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblOriginalCMVNeg
			// 
			this.lblOriginalCMVNeg.Location = new System.Drawing.Point(0, 16);
			this.lblOriginalCMVNeg.Name = "lblOriginalCMVNeg";
			this.lblOriginalCMVNeg.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalCMVNeg.TabIndex = 16;
			this.lblOriginalCMVNeg.Text = "C&MV Neg?";
			this.lblOriginalCMVNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lvOriginalAntigens
			// 
			this.lvOriginalAntigens.AccessibleDescription = "R B C Antigens";
			this.lvOriginalAntigens.AccessibleName = "R B C Antigens";
			this.lvOriginalAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvOriginalAntigens.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								 this.colOriginalAntigen,
																								 this.colOriginalPosNeg});
			this.lvOriginalAntigens.FullRowSelect = true;
			this.lvOriginalAntigens.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.lvOriginalAntigens.Location = new System.Drawing.Point(124, 16);
			this.lvOriginalAntigens.MultiSelect = false;
			this.lvOriginalAntigens.Name = "lvOriginalAntigens";
			this.lvOriginalAntigens.Size = new System.Drawing.Size(120, 54);
			this.lvOriginalAntigens.TabIndex = 19;
			this.lvOriginalAntigens.View = System.Windows.Forms.View.Details;
			// 
			// colOriginalAntigen
			// 
			this.colOriginalAntigen.Text = "";
			this.colOriginalAntigen.Width = 5;
			// 
			// colOriginalPosNeg
			// 
			this.colOriginalPosNeg.Text = "";
			this.colOriginalPosNeg.Width = 5;
			// 
			// lblOriginalRBCAntigens
			// 
			this.lblOriginalRBCAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblOriginalRBCAntigens.Location = new System.Drawing.Point(124, 0);
			this.lblOriginalRBCAntigens.Name = "lblOriginalRBCAntigens";
			this.lblOriginalRBCAntigens.Size = new System.Drawing.Size(100, 16);
			this.lblOriginalRBCAntigens.TabIndex = 10;
			this.lblOriginalRBCAntigens.Text = "RBC Antigens";
			this.lblOriginalRBCAntigens.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbOriginalSickleCellNeg
			// 
			this.cbOriginalSickleCellNeg.AccessibleDescription = "Sickle Cell Negative";
			this.cbOriginalSickleCellNeg.AccessibleName = "Sickle Cell Negative";
			this.cbOriginalSickleCellNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbOriginalSickleCellNeg.Enabled = false;
			this.cbOriginalSickleCellNeg.Location = new System.Drawing.Point(0, 40);
			this.cbOriginalSickleCellNeg.Name = "cbOriginalSickleCellNeg";
			this.cbOriginalSickleCellNeg.Size = new System.Drawing.Size(112, 20);
			this.cbOriginalSickleCellNeg.TabIndex = 18;
			this.cbOriginalSickleCellNeg.Text = "Sickle Cell &Neg";
			// 
			// cbOriginalCMVNeg
			// 
			this.cbOriginalCMVNeg.AccessibleDescription = "C M V Negitive";
			this.cbOriginalCMVNeg.AccessibleName = "C M V Negitive";
			this.cbOriginalCMVNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbOriginalCMVNeg.Enabled = false;
			this.cbOriginalCMVNeg.Location = new System.Drawing.Point(0, 16);
			this.cbOriginalCMVNeg.Name = "cbOriginalCMVNeg";
			this.cbOriginalCMVNeg.Size = new System.Drawing.Size(112, 20);
			this.cbOriginalCMVNeg.TabIndex = 17;
			this.cbOriginalCMVNeg.Text = "C&MV Neg";
			// 
			// txtOriginalDonationType
			// 
			this.txtOriginalDonationType.AccessibleDescription = "Donation Type";
			this.txtOriginalDonationType.AccessibleName = "Donation Type";
			this.txtOriginalDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalDonationType.Location = new System.Drawing.Point(96, 4);
			this.txtOriginalDonationType.Name = "txtOriginalDonationType";
			this.txtOriginalDonationType.ReadOnly = true;
			this.txtOriginalDonationType.Size = new System.Drawing.Size(156, 20);
			this.txtOriginalDonationType.TabIndex = 11;
			this.txtOriginalDonationType.Text = "";
			// 
			// lblOriginalDonationType
			// 
			this.lblOriginalDonationType.Location = new System.Drawing.Point(8, 4);
			this.lblOriginalDonationType.Name = "lblOriginalDonationType";
			this.lblOriginalDonationType.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalDonationType.TabIndex = 65;
			this.lblOriginalDonationType.Text = "Donation Type";
			this.lblOriginalDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlOriginalUnitInfo
			// 
			this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalVolume);
			this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalVolume);
			this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalUnitStatus);
			this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalUnitStatus);
			this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalProductName);
			this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalABORh);
			this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalUnitID);
			this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalProductName);
			this.pnlOriginalUnitInfo.Controls.Add(this.txtOriginalExpirationDate);
			this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalExpirationDate);
			this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalABORh);
			this.pnlOriginalUnitInfo.Controls.Add(this.lblOriginalUnitID);
			this.pnlOriginalUnitInfo.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlOriginalUnitInfo.Location = new System.Drawing.Point(0, 0);
			this.pnlOriginalUnitInfo.Name = "pnlOriginalUnitInfo";
			this.pnlOriginalUnitInfo.Size = new System.Drawing.Size(300, 126);
			this.pnlOriginalUnitInfo.TabIndex = 4;
			// 
			// txtOriginalVolume
			// 
			this.txtOriginalVolume.AccessibleDescription = "Volume Milliliters";
			this.txtOriginalVolume.AccessibleName = "Volume Milliliters";
			this.txtOriginalVolume.Location = new System.Drawing.Point(240, 52);
			this.txtOriginalVolume.Name = "txtOriginalVolume";
			this.txtOriginalVolume.ReadOnly = true;
			this.txtOriginalVolume.Size = new System.Drawing.Size(48, 20);
			this.txtOriginalVolume.TabIndex = 8;
			this.txtOriginalVolume.Text = "";
			// 
			// lblOriginalVolume
			// 
			this.lblOriginalVolume.Location = new System.Drawing.Point(176, 52);
			this.lblOriginalVolume.Name = "lblOriginalVolume";
			this.lblOriginalVolume.Size = new System.Drawing.Size(68, 20);
			this.lblOriginalVolume.TabIndex = 69;
			this.lblOriginalVolume.Text = "Volume (ml)";
			this.lblOriginalVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOriginalUnitStatus
			// 
			this.txtOriginalUnitStatus.AccessibleDescription = "Unit Status";
			this.txtOriginalUnitStatus.AccessibleName = "Unit Status";
			this.txtOriginalUnitStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalUnitStatus.Location = new System.Drawing.Point(88, 100);
			this.txtOriginalUnitStatus.Name = "txtOriginalUnitStatus";
			this.txtOriginalUnitStatus.ReadOnly = true;
			this.txtOriginalUnitStatus.Size = new System.Drawing.Size(200, 20);
			this.txtOriginalUnitStatus.TabIndex = 10;
			this.txtOriginalUnitStatus.Text = "";
			// 
			// lblOriginalUnitStatus
			// 
			this.lblOriginalUnitStatus.Location = new System.Drawing.Point(4, 100);
			this.lblOriginalUnitStatus.Name = "lblOriginalUnitStatus";
			this.lblOriginalUnitStatus.Size = new System.Drawing.Size(88, 20);
			this.lblOriginalUnitStatus.TabIndex = 68;
			this.lblOriginalUnitStatus.Text = "Unit Status";
			this.lblOriginalUnitStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOriginalProductName
			// 
			this.txtOriginalProductName.AccessibleDescription = "Product";
			this.txtOriginalProductName.AccessibleName = "Product";
			this.txtOriginalProductName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalProductName.Location = new System.Drawing.Point(88, 28);
			this.txtOriginalProductName.Name = "txtOriginalProductName";
			this.txtOriginalProductName.ReadOnly = true;
			this.txtOriginalProductName.Size = new System.Drawing.Size(200, 20);
			this.txtOriginalProductName.TabIndex = 6;
			this.txtOriginalProductName.Text = "";
			// 
			// txtOriginalABORh
			// 
			this.txtOriginalABORh.AccessibleDescription = "A B O R H";
			this.txtOriginalABORh.AccessibleName = "A B O R H";
			this.txtOriginalABORh.Location = new System.Drawing.Point(88, 52);
			this.txtOriginalABORh.Name = "txtOriginalABORh";
			this.txtOriginalABORh.ReadOnly = true;
			this.txtOriginalABORh.Size = new System.Drawing.Size(80, 20);
			this.txtOriginalABORh.TabIndex = 7;
			this.txtOriginalABORh.Text = "";
			// 
			// txtOriginalUnitID
			// 
			this.txtOriginalUnitID.AccessibleDescription = "Unit I D";
			this.txtOriginalUnitID.AccessibleName = "Unit I D";
			this.txtOriginalUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalUnitID.Location = new System.Drawing.Point(88, 4);
			this.txtOriginalUnitID.Name = "txtOriginalUnitID";
			this.txtOriginalUnitID.ReadOnly = true;
			this.txtOriginalUnitID.Size = new System.Drawing.Size(200, 20);
			this.txtOriginalUnitID.TabIndex = 5;
			this.txtOriginalUnitID.Text = "";
			// 
			// lblOriginalProductName
			// 
			this.lblOriginalProductName.Location = new System.Drawing.Point(4, 28);
			this.lblOriginalProductName.Name = "lblOriginalProductName";
			this.lblOriginalProductName.Size = new System.Drawing.Size(96, 20);
			this.lblOriginalProductName.TabIndex = 66;
			this.lblOriginalProductName.Text = "Product";
			this.lblOriginalProductName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOriginalExpirationDate
			// 
			this.txtOriginalExpirationDate.AccessibleDescription = "Expiration Date";
			this.txtOriginalExpirationDate.AccessibleName = "Expiration Date";
			this.txtOriginalExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalExpirationDate.Location = new System.Drawing.Point(88, 76);
			this.txtOriginalExpirationDate.Name = "txtOriginalExpirationDate";
			this.txtOriginalExpirationDate.ReadOnly = true;
			this.txtOriginalExpirationDate.Size = new System.Drawing.Size(200, 20);
			this.txtOriginalExpirationDate.TabIndex = 9;
			this.txtOriginalExpirationDate.Text = "";
			// 
			// lblOriginalExpirationDate
			// 
			this.lblOriginalExpirationDate.Location = new System.Drawing.Point(4, 76);
			this.lblOriginalExpirationDate.Name = "lblOriginalExpirationDate";
			this.lblOriginalExpirationDate.Size = new System.Drawing.Size(88, 20);
			this.lblOriginalExpirationDate.TabIndex = 64;
			this.lblOriginalExpirationDate.Text = "Expiration Date";
			this.lblOriginalExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblOriginalABORh
			// 
			this.lblOriginalABORh.Location = new System.Drawing.Point(4, 52);
			this.lblOriginalABORh.Name = "lblOriginalABORh";
			this.lblOriginalABORh.Size = new System.Drawing.Size(80, 20);
			this.lblOriginalABORh.TabIndex = 63;
			this.lblOriginalABORh.Text = "ABO/Rh";
			this.lblOriginalABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblOriginalUnitID
			// 
			this.lblOriginalUnitID.Location = new System.Drawing.Point(4, 4);
			this.lblOriginalUnitID.Name = "lblOriginalUnitID";
			this.lblOriginalUnitID.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalUnitID.TabIndex = 62;
			this.lblOriginalUnitID.Text = "Unit ID";
			this.lblOriginalUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// tabPool
			// 
			this.tabPool.AccessibleDescription = "Pooled Unit";
			this.tabPool.AccessibleName = "Pooled Unit";
			this.tabPool.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabPool.Controls.Add(this.pagePool);
			this.tabPool.Location = new System.Drawing.Point(56, 216);
			this.tabPool.Name = "tabPool";
			this.tabPool.SelectedIndex = 0;
			this.tabPool.Size = new System.Drawing.Size(564, 246);
			this.tabPool.TabIndex = 20;
			// 
			// pagePool
			// 
			this.pagePool.Controls.Add(this.pnlTargetUnit);
			this.pagePool.Location = new System.Drawing.Point(4, 23);
			this.pagePool.Name = "pagePool";
			this.pagePool.Size = new System.Drawing.Size(556, 219);
			this.pagePool.TabIndex = 0;
			this.pagePool.Text = "Pooled Unit";
			// 
			// pnlTargetUnit
			// 
			this.pnlTargetUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlTargetUnit.Controls.Add(this.tabSuppliesEquipment);
			this.pnlTargetUnit.Controls.Add(this.pnlTargetTop);
			this.pnlTargetUnit.Location = new System.Drawing.Point(-4, -2);
			this.pnlTargetUnit.Name = "pnlTargetUnit";
			this.pnlTargetUnit.Size = new System.Drawing.Size(564, 222);
			this.pnlTargetUnit.TabIndex = 20;
			// 
			// tabSuppliesEquipment
			// 
			this.tabSuppliesEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabSuppliesEquipment.Controls.Add(this.pageContainer);
			this.tabSuppliesEquipment.Controls.Add(this.pageSupplies);
			this.tabSuppliesEquipment.Controls.Add(this.pageEquipment);
			this.tabSuppliesEquipment.Controls.Add(this.pageSCDWafer);
			this.tabSuppliesEquipment.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tabSuppliesEquipment.Location = new System.Drawing.Point(4, 124);
			this.tabSuppliesEquipment.Multiline = true;
			this.tabSuppliesEquipment.Name = "tabSuppliesEquipment";
			this.tabSuppliesEquipment.SelectedIndex = 0;
			this.tabSuppliesEquipment.Size = new System.Drawing.Size(556, 98);
			this.tabSuppliesEquipment.TabIndex = 36;
			this.tabSuppliesEquipment.SelectedIndexChanged += new System.EventHandler(this.tabSuppliesEquipment_SelectedIndexChanged);
			// 
			// pageContainer
			// 
			this.pageContainer.Controls.Add(this.btnAddContainer);
			this.pageContainer.Controls.Add(this.lvContainer);
			this.pageContainer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageContainer.Location = new System.Drawing.Point(4, 21);
			this.pageContainer.Name = "pageContainer";
			this.pageContainer.Size = new System.Drawing.Size(548, 73);
			this.pageContainer.TabIndex = 2;
			this.pageContainer.Text = "Container";
			// 
			// btnAddContainer
			// 
			this.btnAddContainer.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAddContainer.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnAddContainer.Location = new System.Drawing.Point(452, 4);
			this.btnAddContainer.Name = "btnAddContainer";
			this.btnAddContainer.Size = new System.Drawing.Size(96, 23);
			this.btnAddContainer.TabIndex = 38;
			this.btnAddContainer.Text = "&Add Container";
			this.btnAddContainer.Click += new System.EventHandler(this.btnAddContainer_Click);
			// 
			// lvContainer
			// 
			this.lvContainer.AccessibleDescription = "Container";
			this.lvContainer.AccessibleName = "Container";
			this.lvContainer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvContainer.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.columnHeader1,
																						  this.columnHeader2,
																						  this.columnHeader3,
																						  this.columnHeader4});
			this.lvContainer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvContainer.FullRowSelect = true;
			this.lvContainer.Location = new System.Drawing.Point(0, 0);
			this.lvContainer.MultiSelect = false;
			this.lvContainer.Name = "lvContainer";
			this.lvContainer.Size = new System.Drawing.Size(448, 64);
			this.lvContainer.TabIndex = 37;
			this.lvContainer.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Lot Number";
			this.columnHeader1.Width = 70;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Supply Type";
			this.columnHeader2.Width = 150;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Manufacturer";
			this.columnHeader3.Width = 120;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Expires";
			this.columnHeader4.Width = 80;
			// 
			// pageSupplies
			// 
			this.pageSupplies.Controls.Add(this.btnAddSupplies);
			this.pageSupplies.Controls.Add(this.lvSupplies);
			this.pageSupplies.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageSupplies.Location = new System.Drawing.Point(4, 21);
			this.pageSupplies.Name = "pageSupplies";
			this.pageSupplies.Size = new System.Drawing.Size(548, 73);
			this.pageSupplies.TabIndex = 0;
			this.pageSupplies.Text = "Supplies";
			this.pageSupplies.Visible = false;
			// 
			// btnAddSupplies
			// 
			this.btnAddSupplies.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAddSupplies.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnAddSupplies.Location = new System.Drawing.Point(452, 4);
			this.btnAddSupplies.Name = "btnAddSupplies";
			this.btnAddSupplies.Size = new System.Drawing.Size(96, 23);
			this.btnAddSupplies.TabIndex = 40;
			this.btnAddSupplies.Text = "Add &Supplies";
			this.btnAddSupplies.Click += new System.EventHandler(this.btnAddSupplies_Click);
			// 
			// lvSupplies
			// 
			this.lvSupplies.AccessibleDescription = "Supplies";
			this.lvSupplies.AccessibleName = "Supplies";
			this.lvSupplies.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSupplies.CheckBoxes = true;
			this.lvSupplies.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.colSupplyCheckbox,
																						 this.colSupplyLotNumber,
																						 this.colSupplyName,
																						 this.colSupplyManufacturer,
																						 this.colSupplyExpires});
			this.lvSupplies.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvSupplies.FullRowSelect = true;
			this.lvSupplies.Location = new System.Drawing.Point(0, 0);
			this.lvSupplies.MultiSelect = false;
			this.lvSupplies.Name = "lvSupplies";
			this.lvSupplies.Size = new System.Drawing.Size(448, 72);
			this.lvSupplies.TabIndex = 39;
			this.lvSupplies.View = System.Windows.Forms.View.Details;
			this.lvSupplies.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSupplies_ColumnClick);
			this.lvSupplies.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvSupplies_ItemCheck);
			// 
			// colSupplyCheckbox
			// 
			this.colSupplyCheckbox.Text = "";
			this.colSupplyCheckbox.Width = 20;
			// 
			// colSupplyLotNumber
			// 
			this.colSupplyLotNumber.Text = "Lot Number";
			this.colSupplyLotNumber.Width = 70;
			// 
			// colSupplyName
			// 
			this.colSupplyName.Text = "Supply Type";
			this.colSupplyName.Width = 150;
			// 
			// colSupplyManufacturer
			// 
			this.colSupplyManufacturer.Text = "Manufacturer";
			this.colSupplyManufacturer.Width = 120;
			// 
			// colSupplyExpires
			// 
			this.colSupplyExpires.Text = "Expires";
			this.colSupplyExpires.Width = 80;
			// 
			// pageEquipment
			// 
			this.pageEquipment.Controls.Add(this.btnAddEquipment);
			this.pageEquipment.Controls.Add(this.lvEquipment);
			this.pageEquipment.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageEquipment.Location = new System.Drawing.Point(4, 21);
			this.pageEquipment.Name = "pageEquipment";
			this.pageEquipment.Size = new System.Drawing.Size(548, 73);
			this.pageEquipment.TabIndex = 1;
			this.pageEquipment.Text = "Equipment";
			this.pageEquipment.Visible = false;
			// 
			// btnAddEquipment
			// 
			this.btnAddEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAddEquipment.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnAddEquipment.Location = new System.Drawing.Point(452, 4);
			this.btnAddEquipment.Name = "btnAddEquipment";
			this.btnAddEquipment.Size = new System.Drawing.Size(96, 23);
			this.btnAddEquipment.TabIndex = 42;
			this.btnAddEquipment.Text = "Add &Equipment";
			this.btnAddEquipment.Click += new System.EventHandler(this.btnAddEquipment_Click);
			// 
			// lvEquipment
			// 
			this.lvEquipment.AccessibleDescription = "Equipment";
			this.lvEquipment.AccessibleName = "Equipment";
			this.lvEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvEquipment.CheckBoxes = true;
			this.lvEquipment.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.colEquipmentCheckbox,
																						  this.colSerialNumber,
																						  this.colEquipmentName,
																						  this.colEquipmentManufacturer,
																						  this.colLocalID});
			this.lvEquipment.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvEquipment.FullRowSelect = true;
			this.lvEquipment.Location = new System.Drawing.Point(0, 0);
			this.lvEquipment.MultiSelect = false;
			this.lvEquipment.Name = "lvEquipment";
			this.lvEquipment.Size = new System.Drawing.Size(448, 72);
			this.lvEquipment.TabIndex = 41;
			this.lvEquipment.View = System.Windows.Forms.View.Details;
			this.lvEquipment.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvEquipment_ColumnClick);
			this.lvEquipment.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvEquipment_ItemCheck);
			// 
			// colEquipmentCheckbox
			// 
			this.colEquipmentCheckbox.Text = "";
			this.colEquipmentCheckbox.Width = 20;
			// 
			// colSerialNumber
			// 
			this.colSerialNumber.Text = "ID Number";
			this.colSerialNumber.Width = 70;
			// 
			// colEquipmentName
			// 
			this.colEquipmentName.Text = "Equipment Name";
			this.colEquipmentName.Width = 150;
			// 
			// colEquipmentManufacturer
			// 
			this.colEquipmentManufacturer.Text = "Manufacturer";
			this.colEquipmentManufacturer.Width = 120;
			// 
			// colLocalID
			// 
			this.colLocalID.Text = "Local ID";
			this.colLocalID.Width = 80;
			// 
			// pageSCDWafer
			// 
			this.pageSCDWafer.Controls.Add(this.btnAddWafer);
			this.pageSCDWafer.Controls.Add(this.lvSCDWafer);
			this.pageSCDWafer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageSCDWafer.Location = new System.Drawing.Point(4, 21);
			this.pageSCDWafer.Name = "pageSCDWafer";
			this.pageSCDWafer.Size = new System.Drawing.Size(548, 73);
			this.pageSCDWafer.TabIndex = 3;
			this.pageSCDWafer.Text = "SCD Wafer";
			this.pageSCDWafer.Visible = false;
			// 
			// btnAddWafer
			// 
			this.btnAddWafer.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAddWafer.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnAddWafer.Location = new System.Drawing.Point(452, 4);
			this.btnAddWafer.Name = "btnAddWafer";
			this.btnAddWafer.Size = new System.Drawing.Size(96, 23);
			this.btnAddWafer.TabIndex = 44;
			this.btnAddWafer.Text = "Add &Wafer";
			this.btnAddWafer.Click += new System.EventHandler(this.btnAddWafer_Click);
			// 
			// lvSCDWafer
			// 
			this.lvSCDWafer.AccessibleDescription = "S C D Wafer";
			this.lvSCDWafer.AccessibleName = "S C D Wafer";
			this.lvSCDWafer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSCDWafer.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader5,
																						 this.columnHeader6,
																						 this.columnHeader7,
																						 this.columnHeader8});
			this.lvSCDWafer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvSCDWafer.FullRowSelect = true;
			this.lvSCDWafer.Location = new System.Drawing.Point(0, 0);
			this.lvSCDWafer.MultiSelect = false;
			this.lvSCDWafer.Name = "lvSCDWafer";
			this.lvSCDWafer.Size = new System.Drawing.Size(448, 64);
			this.lvSCDWafer.TabIndex = 43;
			this.lvSCDWafer.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Lot Number";
			this.columnHeader5.Width = 70;
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Supply Type";
			this.columnHeader6.Width = 150;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "Manufacturer";
			this.columnHeader7.Width = 120;
			// 
			// columnHeader8
			// 
			this.columnHeader8.Text = "Expires";
			this.columnHeader8.Width = 80;
			// 
			// pnlTargetTop
			// 
			this.pnlTargetTop.Controls.Add(this.pnlTargetExtraInfo);
			this.pnlTargetTop.Controls.Add(this.pnlTargetUnitInfo);
			this.pnlTargetTop.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlTargetTop.Location = new System.Drawing.Point(0, 0);
			this.pnlTargetTop.Name = "pnlTargetTop";
			this.pnlTargetTop.Size = new System.Drawing.Size(564, 124);
			this.pnlTargetTop.TabIndex = 20;
			// 
			// pnlTargetExtraInfo
			// 
			this.pnlTargetExtraInfo.Controls.Add(this.tabTargetExtraInfo);
			this.pnlTargetExtraInfo.Controls.Add(this.txtTargetDonationType);
			this.pnlTargetExtraInfo.Controls.Add(this.lblTargetDonationType);
			this.pnlTargetExtraInfo.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlTargetExtraInfo.Location = new System.Drawing.Point(304, 0);
			this.pnlTargetExtraInfo.Name = "pnlTargetExtraInfo";
			this.pnlTargetExtraInfo.Size = new System.Drawing.Size(260, 124);
			this.pnlTargetExtraInfo.TabIndex = 27;
			// 
			// tabTargetExtraInfo
			// 
			this.tabTargetExtraInfo.Alignment = System.Windows.Forms.TabAlignment.Bottom;
			this.tabTargetExtraInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabTargetExtraInfo.Controls.Add(this.pageTargetRestricted);
			this.tabTargetExtraInfo.Controls.Add(this.pageTargetAssigned);
			this.tabTargetExtraInfo.Controls.Add(this.pageTargetSpecialTesting);
			this.tabTargetExtraInfo.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tabTargetExtraInfo.Location = new System.Drawing.Point(4, 24);
			this.tabTargetExtraInfo.Multiline = true;
			this.tabTargetExtraInfo.Name = "tabTargetExtraInfo";
			this.tabTargetExtraInfo.SelectedIndex = 0;
			this.tabTargetExtraInfo.Size = new System.Drawing.Size(252, 100);
			this.tabTargetExtraInfo.TabIndex = 28;
			this.tabTargetExtraInfo.SelectedIndexChanged += new System.EventHandler(this.ExtraInfoTabsClicked);
			// 
			// pageTargetRestricted
			// 
			this.pageTargetRestricted.Controls.Add(this.picTargetBiohazard);
			this.pageTargetRestricted.Controls.Add(this.txtTargetRestrictedStatus);
			this.pageTargetRestricted.Controls.Add(this.lblTargetTestingStatus);
			this.pageTargetRestricted.Controls.Add(this.txtTargetRestrictedSSN);
			this.pageTargetRestricted.Controls.Add(this.txtTargetRestrictedName);
			this.pageTargetRestricted.Controls.Add(this.lblTargetRestrictedSSN);
			this.pageTargetRestricted.Controls.Add(this.lblTargetRestrictedName);
			this.pageTargetRestricted.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageTargetRestricted.Location = new System.Drawing.Point(4, 4);
			this.pageTargetRestricted.Name = "pageTargetRestricted";
			this.pageTargetRestricted.Size = new System.Drawing.Size(244, 75);
			this.pageTargetRestricted.TabIndex = 0;
			this.pageTargetRestricted.Text = "Restricted For";
			// 
			// picTargetBiohazard
			// 
			this.picTargetBiohazard.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.picTargetBiohazard.Image = ((System.Drawing.Image)(resources.GetObject("picTargetBiohazard.Image")));
			this.picTargetBiohazard.Location = new System.Drawing.Point(216, 40);
			this.picTargetBiohazard.Name = "picTargetBiohazard";
			this.picTargetBiohazard.Size = new System.Drawing.Size(26, 28);
			this.picTargetBiohazard.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picTargetBiohazard.TabIndex = 35;
			this.picTargetBiohazard.TabStop = false;
			this.picTargetBiohazard.Visible = false;
			// 
			// txtTargetRestrictedStatus
			// 
			this.txtTargetRestrictedStatus.AccessibleDescription = "Disease Marker Testing";
			this.txtTargetRestrictedStatus.AccessibleName = "Disease Marker Testing";
			this.txtTargetRestrictedStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetRestrictedStatus.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtTargetRestrictedStatus.Location = new System.Drawing.Point(88, 48);
			this.txtTargetRestrictedStatus.Name = "txtTargetRestrictedStatus";
			this.txtTargetRestrictedStatus.ReadOnly = true;
			this.txtTargetRestrictedStatus.Size = new System.Drawing.Size(124, 20);
			this.txtTargetRestrictedStatus.TabIndex = 31;
			this.txtTargetRestrictedStatus.Text = "";
			this.txtTargetRestrictedStatus.TextChanged += new System.EventHandler(this.txtTargetRestrictedStatus_TextChanged);
			// 
			// lblTargetTestingStatus
			// 
			this.lblTargetTestingStatus.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblTargetTestingStatus.Location = new System.Drawing.Point(0, 48);
			this.lblTargetTestingStatus.Name = "lblTargetTestingStatus";
			this.lblTargetTestingStatus.Size = new System.Drawing.Size(92, 24);
			this.lblTargetTestingStatus.TabIndex = 15;
			this.lblTargetTestingStatus.Text = "Disease Marker Testing";
			this.lblTargetTestingStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtTargetRestrictedSSN
			// 
			this.txtTargetRestrictedSSN.AccessibleDescription = "Patient I D";
			this.txtTargetRestrictedSSN.AccessibleName = "Patient I D";
			this.txtTargetRestrictedSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetRestrictedSSN.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtTargetRestrictedSSN.Location = new System.Drawing.Point(88, 24);
			this.txtTargetRestrictedSSN.Name = "txtTargetRestrictedSSN";
			this.txtTargetRestrictedSSN.ReadOnly = true;
			this.txtTargetRestrictedSSN.Size = new System.Drawing.Size(124, 20);
			this.txtTargetRestrictedSSN.TabIndex = 30;
			this.txtTargetRestrictedSSN.Text = "";
			// 
			// txtTargetRestrictedName
			// 
			this.txtTargetRestrictedName.AccessibleDescription = "Patient Name";
			this.txtTargetRestrictedName.AccessibleName = "Patient Name";
			this.txtTargetRestrictedName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetRestrictedName.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtTargetRestrictedName.Location = new System.Drawing.Point(88, 0);
			this.txtTargetRestrictedName.Name = "txtTargetRestrictedName";
			this.txtTargetRestrictedName.ReadOnly = true;
			this.txtTargetRestrictedName.Size = new System.Drawing.Size(156, 20);
			this.txtTargetRestrictedName.TabIndex = 29;
			this.txtTargetRestrictedName.Text = "";
			// 
			// lblTargetRestrictedSSN
			// 
			this.lblTargetRestrictedSSN.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblTargetRestrictedSSN.Location = new System.Drawing.Point(0, 24);
			this.lblTargetRestrictedSSN.Name = "lblTargetRestrictedSSN";
			this.lblTargetRestrictedSSN.Size = new System.Drawing.Size(92, 20);
			this.lblTargetRestrictedSSN.TabIndex = 12;
			this.lblTargetRestrictedSSN.Text = "Patient ID";
			this.lblTargetRestrictedSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetRestrictedName
			// 
			this.lblTargetRestrictedName.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblTargetRestrictedName.Location = new System.Drawing.Point(0, 0);
			this.lblTargetRestrictedName.Name = "lblTargetRestrictedName";
			this.lblTargetRestrictedName.Size = new System.Drawing.Size(92, 20);
			this.lblTargetRestrictedName.TabIndex = 11;
			this.lblTargetRestrictedName.Text = "Patient Name";
			this.lblTargetRestrictedName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pageTargetAssigned
			// 
			this.pageTargetAssigned.Controls.Add(this.lvTargetAssigned);
			this.pageTargetAssigned.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageTargetAssigned.Location = new System.Drawing.Point(4, 4);
			this.pageTargetAssigned.Name = "pageTargetAssigned";
			this.pageTargetAssigned.Size = new System.Drawing.Size(244, 75);
			this.pageTargetAssigned.TabIndex = 1;
			this.pageTargetAssigned.Text = "Assigned To";
			this.pageTargetAssigned.Visible = false;
			// 
			// lvTargetAssigned
			// 
			this.lvTargetAssigned.AccessibleDescription = "Assigned To";
			this.lvTargetAssigned.AccessibleName = "Assigned To";
			this.lvTargetAssigned.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvTargetAssigned.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this.columnHeader13,
																							   this.columnHeader14,
																							   this.columnHeader15,
																							   this.columnHeader16});
			this.lvTargetAssigned.Location = new System.Drawing.Point(0, 0);
			this.lvTargetAssigned.Name = "lvTargetAssigned";
			this.lvTargetAssigned.Size = new System.Drawing.Size(244, 72);
			this.lvTargetAssigned.TabIndex = 32;
			this.lvTargetAssigned.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader13
			// 
			this.columnHeader13.Text = "Patient Name";
			this.columnHeader13.Width = 80;
			// 
			// columnHeader14
			// 
			this.columnHeader14.Text = "Patient ID";
			// 
			// columnHeader15
			// 
			this.columnHeader15.Text = "Specimen UID";
			this.columnHeader15.Width = 80;
			// 
			// columnHeader16
			// 
			this.columnHeader16.Text = "Specimen Expires";
			this.columnHeader16.Width = 100;
			// 
			// pageTargetSpecialTesting
			// 
			this.pageTargetSpecialTesting.Controls.Add(this.lblTargetSickleCellNeg);
			this.pageTargetSpecialTesting.Controls.Add(this.lblTargetCMVNeg);
			this.pageTargetSpecialTesting.Controls.Add(this.lvTargetAntigens);
			this.pageTargetSpecialTesting.Controls.Add(this.lblTargetRBCAntigens);
			this.pageTargetSpecialTesting.Controls.Add(this.cbTargetSickleCellNeg);
			this.pageTargetSpecialTesting.Controls.Add(this.cbTargetCMVNeg);
			this.pageTargetSpecialTesting.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageTargetSpecialTesting.Location = new System.Drawing.Point(4, 4);
			this.pageTargetSpecialTesting.Name = "pageTargetSpecialTesting";
			this.pageTargetSpecialTesting.Size = new System.Drawing.Size(244, 75);
			this.pageTargetSpecialTesting.TabIndex = 2;
			this.pageTargetSpecialTesting.Text = "Special Testing";
			this.pageTargetSpecialTesting.Visible = false;
			// 
			// lblTargetSickleCellNeg
			// 
			this.lblTargetSickleCellNeg.Location = new System.Drawing.Point(0, 40);
			this.lblTargetSickleCellNeg.Name = "lblTargetSickleCellNeg";
			this.lblTargetSickleCellNeg.Size = new System.Drawing.Size(92, 20);
			this.lblTargetSickleCellNeg.TabIndex = 19;
			this.lblTargetSickleCellNeg.Text = "Sic&kle Cell Neg?";
			this.lblTargetSickleCellNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetCMVNeg
			// 
			this.lblTargetCMVNeg.Location = new System.Drawing.Point(0, 16);
			this.lblTargetCMVNeg.Name = "lblTargetCMVNeg";
			this.lblTargetCMVNeg.Size = new System.Drawing.Size(92, 20);
			this.lblTargetCMVNeg.TabIndex = 18;
			this.lblTargetCMVNeg.Text = "CM&V Neg?";
			this.lblTargetCMVNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lvTargetAntigens
			// 
			this.lvTargetAntigens.AccessibleDescription = "R B C Antigens";
			this.lvTargetAntigens.AccessibleName = "R B C Antigens";
			this.lvTargetAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvTargetAntigens.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this.colTargetAntigens,
																							   this.colTargetPosNeg});
			this.lvTargetAntigens.FullRowSelect = true;
			this.lvTargetAntigens.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.lvTargetAntigens.Location = new System.Drawing.Point(124, 16);
			this.lvTargetAntigens.MultiSelect = false;
			this.lvTargetAntigens.Name = "lvTargetAntigens";
			this.lvTargetAntigens.Size = new System.Drawing.Size(120, 56);
			this.lvTargetAntigens.TabIndex = 35;
			this.lvTargetAntigens.View = System.Windows.Forms.View.Details;
			// 
			// colTargetAntigens
			// 
			this.colTargetAntigens.Text = "";
			this.colTargetAntigens.Width = 5;
			// 
			// colTargetPosNeg
			// 
			this.colTargetPosNeg.Text = "";
			this.colTargetPosNeg.Width = 35;
			// 
			// lblTargetRBCAntigens
			// 
			this.lblTargetRBCAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblTargetRBCAntigens.Location = new System.Drawing.Point(124, 0);
			this.lblTargetRBCAntigens.Name = "lblTargetRBCAntigens";
			this.lblTargetRBCAntigens.Size = new System.Drawing.Size(96, 16);
			this.lblTargetRBCAntigens.TabIndex = 2;
			this.lblTargetRBCAntigens.Text = "RBC Antigens";
			this.lblTargetRBCAntigens.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbTargetSickleCellNeg
			// 
			this.cbTargetSickleCellNeg.AccessibleDescription = "Sickle Cell Negative";
			this.cbTargetSickleCellNeg.AccessibleName = "Sickle Cell Negative";
			this.cbTargetSickleCellNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbTargetSickleCellNeg.Enabled = false;
			this.cbTargetSickleCellNeg.Location = new System.Drawing.Point(0, 40);
			this.cbTargetSickleCellNeg.Name = "cbTargetSickleCellNeg";
			this.cbTargetSickleCellNeg.Size = new System.Drawing.Size(112, 20);
			this.cbTargetSickleCellNeg.TabIndex = 34;
			this.cbTargetSickleCellNeg.Text = "Sic&kle Cell Neg";
			// 
			// cbTargetCMVNeg
			// 
			this.cbTargetCMVNeg.AccessibleDescription = "C M V negative";
			this.cbTargetCMVNeg.AccessibleName = "C M V negative";
			this.cbTargetCMVNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbTargetCMVNeg.Enabled = false;
			this.cbTargetCMVNeg.Location = new System.Drawing.Point(0, 16);
			this.cbTargetCMVNeg.Name = "cbTargetCMVNeg";
			this.cbTargetCMVNeg.Size = new System.Drawing.Size(112, 20);
			this.cbTargetCMVNeg.TabIndex = 33;
			this.cbTargetCMVNeg.Text = "CM&V Neg";
			// 
			// txtTargetDonationType
			// 
			this.txtTargetDonationType.AccessibleDescription = "Donation Type";
			this.txtTargetDonationType.AccessibleName = "Donation Type";
			this.txtTargetDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetDonationType.Location = new System.Drawing.Point(96, 4);
			this.txtTargetDonationType.Name = "txtTargetDonationType";
			this.txtTargetDonationType.ReadOnly = true;
			this.txtTargetDonationType.Size = new System.Drawing.Size(156, 20);
			this.txtTargetDonationType.TabIndex = 27;
			this.txtTargetDonationType.Text = "";
			// 
			// lblTargetDonationType
			// 
			this.lblTargetDonationType.Location = new System.Drawing.Point(8, 4);
			this.lblTargetDonationType.Name = "lblTargetDonationType";
			this.lblTargetDonationType.Size = new System.Drawing.Size(92, 20);
			this.lblTargetDonationType.TabIndex = 127;
			this.lblTargetDonationType.Text = "Donation Type";
			this.lblTargetDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlTargetUnitInfo
			// 
			this.pnlTargetUnitInfo.Controls.Add(this.dtpTargetExpirationDate);
			this.pnlTargetUnitInfo.Controls.Add(this.updTargetVolume);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetVolume);
			this.pnlTargetUnitInfo.Controls.Add(this.txtTargetUnitStatus);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetUnitStatus);
			this.pnlTargetUnitInfo.Controls.Add(this.cmbTargetProductName);
			this.pnlTargetUnitInfo.Controls.Add(this.txtTargetABORh);
			this.pnlTargetUnitInfo.Controls.Add(this.txtTargetUnitId);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetProductName);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetExpirationDate);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetABORh);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetUnitId);
			this.pnlTargetUnitInfo.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlTargetUnitInfo.Location = new System.Drawing.Point(0, 0);
			this.pnlTargetUnitInfo.Name = "pnlTargetUnitInfo";
			this.pnlTargetUnitInfo.Size = new System.Drawing.Size(304, 124);
			this.pnlTargetUnitInfo.TabIndex = 21;
			// 
			// dtpTargetExpirationDate
			// 
			this.dtpTargetExpirationDate.AccessibleDescription = "Expiration Date";
			this.dtpTargetExpirationDate.AccessibleName = "Expiration Date";
			this.dtpTargetExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpTargetExpirationDate.CustomFormat = "";
			this.dtpTargetExpirationDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpTargetExpirationDate.Location = new System.Drawing.Point(92, 76);
			this.dtpTargetExpirationDate.MinDate = new System.DateTime(1920, 1, 1, 0, 0, 0, 0);
			this.dtpTargetExpirationDate.Name = "dtpTargetExpirationDate";
			this.dtpTargetExpirationDate.TabIndex = 25;
			this.dtpTargetExpirationDate.Leave += new System.EventHandler(this.dtpTargetExpirationDate_Leave);
			this.dtpTargetExpirationDate.MouseUp += new System.Windows.Forms.MouseEventHandler(this.dtpTargetExpirationDate_MouseUp);
			// 
			// updTargetVolume
			// 
			this.updTargetVolume.AccessibleDescription = "Volume Milliliters";
			this.updTargetVolume.AccessibleName = "Volume Milliliters";
			this.updTargetVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.updTargetVolume.Location = new System.Drawing.Point(244, 52);
			this.updTargetVolume.Maximum = new System.Decimal(new int[] {
																			2000,
																			0,
																			0,
																			0});
			this.updTargetVolume.Minimum = new System.Decimal(new int[] {
																			1,
																			0,
																			0,
																			0});
			this.updTargetVolume.Name = "updTargetVolume";
			this.updTargetVolume.Size = new System.Drawing.Size(48, 20);
			this.updTargetVolume.TabIndex = 24;
			this.updTargetVolume.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updTargetVolume.Value = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  0});
			this.updTargetVolume.TextChanged += new System.EventHandler(this.updTargetVolume_ValueChanged);
			this.updTargetVolume.Leave += new System.EventHandler(this.updTargetVolume_Leave);
			this.updTargetVolume.ValueChanged += new System.EventHandler(this.updTargetVolume_ValueChanged);
			// 
			// lblTargetVolume
			// 
			this.lblTargetVolume.Location = new System.Drawing.Point(180, 52);
			this.lblTargetVolume.Name = "lblTargetVolume";
			this.lblTargetVolume.Size = new System.Drawing.Size(68, 20);
			this.lblTargetVolume.TabIndex = 133;
			this.lblTargetVolume.Text = "Volume (ml)";
			this.lblTargetVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtTargetUnitStatus
			// 
			this.txtTargetUnitStatus.AccessibleDescription = "Unit Status";
			this.txtTargetUnitStatus.AccessibleName = "Unit Status";
			this.txtTargetUnitStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetUnitStatus.Location = new System.Drawing.Point(92, 100);
			this.txtTargetUnitStatus.Name = "txtTargetUnitStatus";
			this.txtTargetUnitStatus.ReadOnly = true;
			this.txtTargetUnitStatus.Size = new System.Drawing.Size(200, 20);
			this.txtTargetUnitStatus.TabIndex = 26;
			this.txtTargetUnitStatus.Text = "";
			// 
			// lblTargetUnitStatus
			// 
			this.lblTargetUnitStatus.Location = new System.Drawing.Point(8, 100);
			this.lblTargetUnitStatus.Name = "lblTargetUnitStatus";
			this.lblTargetUnitStatus.Size = new System.Drawing.Size(88, 20);
			this.lblTargetUnitStatus.TabIndex = 131;
			this.lblTargetUnitStatus.Text = "Unit Status";
			this.lblTargetUnitStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbTargetProductName
			// 
			this.cmbTargetProductName.AccessibleDescription = "Product";
			this.cmbTargetProductName.AccessibleName = "Product";
			this.cmbTargetProductName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbTargetProductName.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cmbTargetProductName.Interval = 100;
			this.cmbTargetProductName.Location = new System.Drawing.Point(92, 28);
			this.cmbTargetProductName.Name = "cmbTargetProductName";
			this.cmbTargetProductName.Size = new System.Drawing.Size(200, 22);
			this.cmbTargetProductName.TabIndex = 22;
			this.cmbTargetProductName.SelectedIndexChanged += new System.EventHandler(this.cmbTargetProductName_SelectedIndexChanged);
			// 
			// txtTargetABORh
			// 
			this.txtTargetABORh.AccessibleDescription = "A B O R H";
			this.txtTargetABORh.AccessibleName = "A B O R H";
			this.txtTargetABORh.Location = new System.Drawing.Point(92, 52);
			this.txtTargetABORh.Name = "txtTargetABORh";
			this.txtTargetABORh.ReadOnly = true;
			this.txtTargetABORh.Size = new System.Drawing.Size(80, 20);
			this.txtTargetABORh.TabIndex = 23;
			this.txtTargetABORh.Text = "";
			// 
			// txtTargetUnitId
			// 
			this.txtTargetUnitId.AccessibleDescription = "Unit I D ";
			this.txtTargetUnitId.AccessibleName = "Unit I D ";
			this.txtTargetUnitId.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetUnitId.Location = new System.Drawing.Point(92, 4);
			this.txtTargetUnitId.MaxLength = 13;
			this.txtTargetUnitId.Name = "txtTargetUnitId";
			this.txtTargetUnitId.Size = new System.Drawing.Size(200, 20);
			this.txtTargetUnitId.TabIndex = 21;
			this.txtTargetUnitId.Text = "";
			this.txtTargetUnitId.Leave += new System.EventHandler(this.txtTargetUnitId_Leave);
			this.txtTargetUnitId.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtTargetUnitId_KeyUp);
			// 
			// lblTargetProductName
			// 
			this.lblTargetProductName.Location = new System.Drawing.Point(8, 28);
			this.lblTargetProductName.Name = "lblTargetProductName";
			this.lblTargetProductName.Size = new System.Drawing.Size(96, 20);
			this.lblTargetProductName.TabIndex = 128;
			this.lblTargetProductName.Text = "Product*";
			this.lblTargetProductName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetExpirationDate
			// 
			this.lblTargetExpirationDate.Location = new System.Drawing.Point(8, 76);
			this.lblTargetExpirationDate.Name = "lblTargetExpirationDate";
			this.lblTargetExpirationDate.Size = new System.Drawing.Size(92, 20);
			this.lblTargetExpirationDate.TabIndex = 126;
			this.lblTargetExpirationDate.Text = "Expiration Date*";
			this.lblTargetExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetABORh
			// 
			this.lblTargetABORh.Location = new System.Drawing.Point(8, 52);
			this.lblTargetABORh.Name = "lblTargetABORh";
			this.lblTargetABORh.Size = new System.Drawing.Size(92, 20);
			this.lblTargetABORh.TabIndex = 125;
			this.lblTargetABORh.Text = "ABO/Rh";
			this.lblTargetABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetUnitId
			// 
			this.lblTargetUnitId.Location = new System.Drawing.Point(8, 4);
			this.lblTargetUnitId.Name = "lblTargetUnitId";
			this.lblTargetUnitId.Size = new System.Drawing.Size(92, 20);
			this.lblTargetUnitId.TabIndex = 124;
			this.lblTargetUnitId.Text = "Unit ID*";
			this.lblTargetUnitId.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox1.Controls.Add(this.pictureBox2);
			this.groupBox1.Location = new System.Drawing.Point(4, 60);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(52, 402);
			this.groupBox1.TabIndex = 7;
			this.groupBox1.TabStop = false;
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(4, 12);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(45, 45);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox2.TabIndex = 0;
			this.pictureBox2.TabStop = false;
			// 
			// tabOriginal
			// 
			this.tabOriginal.AccessibleDescription = "Units";
			this.tabOriginal.AccessibleName = "Units";
			this.tabOriginal.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabOriginal.Controls.Add(this.pageOriginalUnit1);
			this.tabOriginal.Controls.Add(this.pageOriginalUnit2);
			this.tabOriginal.Location = new System.Drawing.Point(56, 64);
			this.tabOriginal.Name = "tabOriginal";
			this.tabOriginal.SelectedIndex = 0;
			this.tabOriginal.Size = new System.Drawing.Size(568, 152);
			this.tabOriginal.TabIndex = 0;
			this.tabOriginal.SelectedIndexChanged += new System.EventHandler(this.tabOriginal_SelectedIndexChanged);
			// 
			// pageOriginalUnit1
			// 
			this.pageOriginalUnit1.Location = new System.Drawing.Point(4, 23);
			this.pageOriginalUnit1.Name = "pageOriginalUnit1";
			this.pageOriginalUnit1.Size = new System.Drawing.Size(560, 125);
			this.pageOriginalUnit1.TabIndex = 0;
			this.pageOriginalUnit1.Text = "Original Unit 1";
			// 
			// pageOriginalUnit2
			// 
			this.pageOriginalUnit2.Location = new System.Drawing.Point(4, 23);
			this.pageOriginalUnit2.Name = "pageOriginalUnit2";
			this.pageOriginalUnit2.Size = new System.Drawing.Size(560, 125);
			this.pageOriginalUnit2.TabIndex = 1;
			this.pageOriginalUnit2.Text = "Original Unit 2";
			// 
			// FrmPoolUnits
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(624, 523);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.pnlTarget);
			this.hlphelpChm.SetHelpKeyword(this, "Pool_Units.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(632, 550);
			this.Name = "FrmPoolUnits";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Pool Units";
			this.Load += new System.EventHandler(this.FrmPoolUnits_Load);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmPoolUnits_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.pnlTarget, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.pnlTarget.ResumeLayout(false);
			this.panel1.ResumeLayout(false);
			this.grpModificationDetails.ResumeLayout(false);
			this.grpPool.ResumeLayout(false);
			this.grpWeld.ResumeLayout(false);
			this.pnlOriginalUnit.ResumeLayout(false);
			this.pnlOriginalExtraInfo.ResumeLayout(false);
			this.tabOriginalExtraInfo.ResumeLayout(false);
			this.pageOriginalRestricted.ResumeLayout(false);
			this.pageOriginalAssigned.ResumeLayout(false);
			this.pageOriginalSpecialTesting.ResumeLayout(false);
			this.pnlOriginalUnitInfo.ResumeLayout(false);
			this.tabPool.ResumeLayout(false);
			this.pagePool.ResumeLayout(false);
			this.pnlTargetUnit.ResumeLayout(false);
			this.tabSuppliesEquipment.ResumeLayout(false);
			this.pageContainer.ResumeLayout(false);
			this.pageSupplies.ResumeLayout(false);
			this.pageEquipment.ResumeLayout(false);
			this.pageSCDWafer.ResumeLayout(false);
			this.pnlTargetTop.ResumeLayout(false);
			this.pnlTargetExtraInfo.ResumeLayout(false);
			this.tabTargetExtraInfo.ResumeLayout(false);
			this.pageTargetRestricted.ResumeLayout(false);
			this.pageTargetAssigned.ResumeLayout(false);
			this.pageTargetSpecialTesting.ResumeLayout(false);
			this.pnlTargetUnitInfo.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updTargetVolume)).EndInit();
			this.groupBox1.ResumeLayout(false);
			this.tabOriginal.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Functions/Methods

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to initialize UI control properties
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this._targetProductList = new System.Collections.ArrayList();

			this.btnOK.Text = "&OK";
			
			if (this._bumControl.ProductModificationCode == Common.ProductModification.PoolThawCryo)
				this.vbecsLogo1.Title = "Thaw and Pool Cryo";
			else
				this.vbecsLogo1.Title = "Pool Units";

			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC024.FrmPoolUnits());
			//
			//Setup the modification properties -- pooling can't be closed
			switch (this._bumControl.ModificationMethod)
			{
				case (Common.ModifyUnitMethod.Open):
					this.txtMethod.Text = "Open";
					this.EnableContainer(true);
					this.EnableSCDWafer(false);
					this.btnAddContainer.Text = "Add Container*";
					break;

				case (Common.ModifyUnitMethod.SterileConnectingDevice):
					this.txtMethod.Text = "Sterile Connection Device";
					this.EnableContainer(true);
					this.EnableSCDWafer(true);
					this.btnAddContainer.Text = "Add Container*";
					break;
			}
			
			this.txtModificationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._bumControl.ModificationDateTime);
			this.txtNumberOfUnits.Text = this._bumControl.PoolingUnits.Count.ToString();

			this.btnOK.EnabledButton = false;

			//set custom date and time format
			this.dtpTargetExpirationDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			this.dtpTargetExpirationDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			//Set the tooltips
			this.toolTip1.SetToolTip(this.txtOriginalProductName, ((BOL.BloodUnit)this._bumControl.PoolingUnits[0]).ProductName);
			this.toolTip1.SetToolTip(this.rdoComplete, Common.StrRes.Tooltips.UC026.CompleteWeld().ResString);
			this.toolTip1.SetToolTip(this.rdoIncomplete, Common.StrRes.Tooltips.UC026.IncompleteWeld().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalRestrictedStatus, Common.StrRes.Tooltips.UC026.OriginalRestrictedStatus().ResString);
			this.toolTip1.SetToolTip(this.lvSCDWafer, Common.StrRes.Tooltips.UC026.WaferList().ResString);
			this.toolTip1.SetToolTip(this.btnAddWafer, Common.StrRes.Tooltips.UC026.AddWafer().ResString);
			this.toolTip1.SetToolTip(this.lvEquipment, Common.StrRes.Tooltips.UC026.EquipmentList().ResString);
			this.toolTip1.SetToolTip(this.btnAddEquipment, Common.StrRes.Tooltips.UC026.AddEquipment().ResString);
			this.toolTip1.SetToolTip(this.btnAddSupplies, Common.StrRes.Tooltips.UC026.AddSupplies().ResString);
			this.toolTip1.SetToolTip(this.lvContainer, Common.StrRes.Tooltips.UC026.ContainerList().ResString);
			this.toolTip1.SetToolTip(this.btnAddContainer, Common.StrRes.Tooltips.UC026.AddContainer().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalExpirationDate, Common.StrRes.Tooltips.UC026.OriginalExpirationDate().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalUnitID, Common.StrRes.Tooltips.UC026.OriginalUnitId().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalABORh, Common.StrRes.Tooltips.UC026.OriginalAboRH().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalUnitStatus, Common.StrRes.Tooltips.UC026.OriginalUnitStatus().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalVolume, Common.StrRes.Tooltips.UC026.OriginalVolume().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalDonationType, Common.StrRes.Tooltips.UC026.OriginalDonationType().ResString);
			this.toolTip1.SetToolTip(this.cbOriginalCMVNeg, Common.StrRes.Tooltips.UC026.OriginalCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.cbOriginalSickleCellNeg, Common.StrRes.Tooltips.UC026.OriginalSickleCellNeg().ResString);
			this.toolTip1.SetToolTip(this.lvOriginalAntigens, Common.StrRes.Tooltips.UC026.OriginalAntigens().ResString);
			this.toolTip1.SetToolTip(this.lblOriginalCMVNeg, Common.StrRes.Tooltips.UC026.OriginalCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.lblOriginalSickleCellNeg, Common.StrRes.Tooltips.UC026.OriginalSickleCellNeg().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalRestrictedName, Common.StrRes.Tooltips.UC026.OriginalRestrictedName().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalRestrictedSSN, Common.StrRes.Tooltips.UC026.OriginalRestrictedSSN().ResString);
			this.toolTip1.SetToolTip(this.lvSupplies, Common.StrRes.Tooltips.UC026.SupplyList().ResString);
			this.toolTip1.SetToolTip(this.dtpTargetExpirationDate, Common.StrRes.Tooltips.UC026.TargetExpirationDate().ResString);
			this.toolTip1.SetToolTip(this.txtTargetUnitId, Common.StrRes.Tooltips.UC026.TargetUnitId().ResString);
			this.toolTip1.SetToolTip(this.txtTargetABORh, Common.StrRes.Tooltips.UC026.TargetAboRH().ResString);
			this.toolTip1.SetToolTip(this.updTargetVolume, Common.StrRes.Tooltips.UC026.TargetVolume().ResString);
			this.toolTip1.SetToolTip(this.txtTargetUnitStatus, Common.StrRes.Tooltips.UC026.TargetUnitStatus().ResString);
			this.toolTip1.SetToolTip(this.txtTargetDonationType, Common.StrRes.Tooltips.UC026.TargetDonationType().ResString);
			this.toolTip1.SetToolTip(this.cbTargetCMVNeg, Common.StrRes.Tooltips.UC026.TargetCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.cbTargetSickleCellNeg, Common.StrRes.Tooltips.UC026.TargetSickleCellNegative().ResString);
			this.toolTip1.SetToolTip(this.lvTargetAntigens, Common.StrRes.Tooltips.UC026.TargetAntigens().ResString);
			this.toolTip1.SetToolTip(this.lblTargetCMVNeg, Common.StrRes.Tooltips.UC026.TargetCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.lblTargetSickleCellNeg, Common.StrRes.Tooltips.UC026.TargetSickleCellNegative().ResString);
			this.toolTip1.SetToolTip(this.txtTargetRestrictedName, Common.StrRes.Tooltips.UC026.TargetRestrictedName().ResString);
			this.toolTip1.SetToolTip(this.txtTargetRestrictedSSN, Common.StrRes.Tooltips.UC026.TargetRestrictedSSN().ResString);
			this.toolTip1.SetToolTip(this.txtTargetRestrictedStatus, Common.StrRes.Tooltips.UC026.TargetRestrictedStatus().ResString);

		}



		/// <summary>
		/// Sets the enabled properties of the Container listview/Buttons
		/// </summary>
		/// <param name="enable"></param>
		private void EnableContainer(bool enable)
		{
			if (enable)
				this.btnAddContainer.Text = "Add Container*";
			else
				this.btnAddContainer.Text = "Add Container";

			this.lvContainer.Enabled = enable;
			this.btnAddContainer.Enabled = enable;
		}


		/// <summary>
		/// Sets the enabled properties of the SCDWafer listview/Buttons
		/// </summary>
		/// <param name="enable"></param>
		private void EnableSCDWafer(bool enable)
		{
			if (enable)
				this.btnAddWafer.Text = "Add Wafer*";
			else
				this.btnAddWafer.Text = "Add Wafer";

			this.grpWeld.Enabled = enable;
			this.lvSCDWafer.Enabled = enable;
			this.btnAddWafer.Enabled = enable;
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Create a tab for each pooling unit
		/// </summary>
		private void CreateParentTabs()
		{
			int nCount = 0;
			this.tabOriginal.TabPages.Clear();
			nCount = this._bumControl.PoolingUnits.Count;
			for(int ndx=0; ndx < nCount; ndx++)
			{
				BOL.BloodUnit parent = (BOL.BloodUnit)this._bumControl.PoolingUnits[ndx];
				TabPage newPage = new TabPage(parent.EyeReadableUnitId);

				this.tabOriginal.TabPages.Add(newPage);
			}
			
			
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Pivate method to load details of currently selected parent unit into UI controls
		/// </summary>
		private void PopulateSourceDetails()
		{
			this.txtOriginalUnitID.Text			= this._currentPoolingUnit.EyeReadableUnitId;
			this.txtOriginalProductName.Text	= this._currentPoolingUnit.FullProductCode + " - " + this._currentPoolingUnit.ProductShortName;
			this.txtOriginalABORh.Text			= this._currentPoolingUnit.BloodUnitMedia.AboRh.AboRHText;
			this.toolTip1.SetToolTip(this.txtOriginalABORh, this._currentPoolingUnit.BloodUnitMedia.AboRh.AboRHTextExpanded);

			this.txtOriginalExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._currentPoolingUnit.BloodUnitMedia.UnitExpirationDate);
			this.txtOriginalDonationType.Text	= this._currentPoolingUnit.DonationType.DonationTypeText;
			this.txtOriginalUnitStatus.Text		= this._currentPoolingUnit.BloodUnitStatus.UnitStatusDescriptiveText;
			
			this.txtOriginalRestrictedName.Text	= this._currentPoolingUnit.DirectedPatient.DisplayName;
			this.txtOriginalRestrictedSSN.Text	= this._currentPoolingUnit.DirectedPatient.DisplayPatientID;//SSN;
			this.txtOriginalRestrictedStatus.Text = BOL.TestingStatus.GetTestingStatusTextFromID(this._currentPoolingUnit.BloodUnitMedia.TestingStatusId);
			
			this.txtOriginalVolume.Text = this._currentPoolingUnit.OriginalVolume.ToString();

			this.picOriginalBiohazard.Visible	= this._currentPoolingUnit.BloodUnitStatus.BiohazardousWarningIndicator;

			this.lvOrginalAssigned.Items.Clear();
			if (this._currentPoolingUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.CrossmatchedAssigned ||
				this._currentPoolingUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Assigned)
			{
				System.Data.DataTable dtAssignments = BOL.PatientAssignments.GetPatientSpecimenAssignmentDetails(this._currentPoolingUnit.BloodUnitGuid);
				
				foreach(System.Data.DataRow dr in dtAssignments.Rows)
				{
					System.Guid patientGuid = (System.Guid)dr[TABLES.Patient.PatientGuid];
					BOL.Patient patient = new BOL.Patient(patientGuid);

					//Populate the list view with the appropriate data
					ListViewItem lvi = new ListViewItem(patient.DisplayName);
					lvi.SubItems.Add(patient.DisplayPatientID);//patient.SSN.ToString().Insert(3,"-").Insert(6,"-"));
					//
					System.Guid specimenGuid = dr.IsNull(TABLES.PatientSpecimen.PatientSpecimenGuid) ? Guid.Empty : (System.Guid)dr[TABLES.PatientSpecimen.PatientSpecimenGuid];
					if (specimenGuid != Guid.Empty)
					{
						BOL.Specimen specimen = new BOL.Specimen(specimenGuid);
						lvi.SubItems.Add(specimen.SpecimenUid);
						lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(specimen.SpecimenExpirationDate));
					}
					this.lvOrginalAssigned.Items.Add(lvi);
					
				}
				GUI.controls.VbecsFunction.SetColumnWidths(this.lvOrginalAssigned);
			}

			this.cbOriginalCMVNeg.Checked = this._currentPoolingUnit.CmvNegative;
			this.cbOriginalSickleCellNeg.Checked = this._currentPoolingUnit.SickleCellNegative;

			this.PopulateAntigenListview();
			
			//Setup the tooltips
			this.toolTip1.SetToolTip(this.txtOriginalProductName, this._currentPoolingUnit.ProductName);
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/2/2002</CreationDate>
		///
		/// <summary>
		/// Populates the antigens tested, in the little listview
		/// </summary>
		private void PopulateAntigenListview()
		{
			this.lvOriginalAntigens.Items.Clear();

			//This will include antigens from UC1 as well as UC41
			System.Data.DataSet dsAntigens = BOL.DiscardOrQuarantineBloodUnit.GetAntigenTypingForConsistencyCheck(this._currentPoolingUnit.BloodUnitGuid);

			if (dsAntigens.Tables.Count > 1)
			{
				foreach (System.Data.DataRow drItem in dsAntigens.Tables[1].Rows)
				{
					ListViewItem lvi = new ListViewItem();
				
					lvi.Text = drItem[TABLES.AntigenType.AntigenTypeName].ToString().Trim();
									
					if (System.Convert.ToBoolean(drItem[TABLES.BloodUnitAntigen.Positive]))
					{
						lvi.SubItems.Add("POS");
					}
					else
					{
						lvi.SubItems.Add("NEG");
					}
					this.lvOriginalAntigens.Items.Add(lvi);
				}
			}
			
			GUI.controls.VbecsFunction.SetColumnWidths(this.lvOriginalAntigens);
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to search on file for valid target products for current blood unit modification, and populate UI control
		/// Identical code in UC26.FrmModifyUnits
		/// </summary>
		private void PopulateTargetProductSelection()
		{
			try
			{
				int autoIndex = -1;

				//We need this set as form-level so we can access the other information later
				System.Data.DataTable dtProducts = this._bumControl.GetTargetBloodProducts(this._bumControl.GetBloodProductGuidArray());
			
				this.cmbTargetProductName.Items.Clear();
				this._targetProductList.Clear();

				bool isISBT = (this._bumControl.PooledUnit.NewUnit.BarcodeType == Common.BarcodeType.ISBT128);

				foreach (System.Data.DataRow dr in dtProducts.Rows)
				{
					System.Guid bpGuid = (System.Guid)dr[TABLES.BloodProduct.BloodProductGuid];

					if (isISBT)
					{
						string productName = dr[TABLES.BloodProduct.ProductCode].ToString() + this._bumControl.PooledUnit.NewUnit.DonationType.DonationTypeCode.ToString() + this._bumControl.PooledUnit.NewUnit.UnitDivisionId;
						this.cmbTargetProductName.Items.Add(productName + " - " + dr[TABLES.BloodProduct.ProductShortName].ToString());
					}
					else
						this.cmbTargetProductName.Items.Add(dr[Common.DatabaseConstants.ArtificialColumnNames.CodeAndShortName].ToString());

					//Save off the bloodproductguid for later use -- allows us to dump the datatable
					this._targetProductList.Add(dr);

					if (bpGuid == this._bumControl.PooledUnit.NewUnit.BloodProductGuid)
					{
						autoIndex = this._targetProductList.Count - 1;
					}
				}
				
				if (dtProducts.Rows.Count == 0)
					this.toolTip1.SetToolTip(this.cmbTargetProductName, Common.StrRes.Tooltips.UC026.NoTargetProducts().ResString);
				else
				{
					if (this._bumControl.ProductModificationCode == Common.ProductModification.EditPool)
					{
						this.cmbTargetProductName.SelectedIndex = autoIndex;
						this.cmbTargetProductName.Enabled = false;
					}
					else
						this.toolTip1.SetToolTip(this.cmbTargetProductName, Common.StrRes.Tooltips.UC026.SelectTargetProduct().ResString);
				}

			}
			catch (Exception err)
			{
				this.errError.SetVbecsError(this.cmbTargetProductName, err.Message); // **** 508 Compliance ***
			}
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to load details of target pooled unit into UI controls
		/// </summary>
		private void PopulateTargetDetails()
		{
			this.PopulateTargetProductSelection();
			
			this.txtTargetUnitId.Text = this._bumControl.PooledUnit.NewUnit.EyeReadableUnitId;
			//Disabled the UnitID for ISBT units
			if (this._bumControl.PooledUnit.NewUnit.BarcodeType == Common.BarcodeType.ISBT128 ||
				this._bumControl.ProductModificationCode == Common.ProductModification.EditPool)
				this.txtTargetUnitId.Enabled = false;

			this.txtTargetABORh.Text = this._bumControl.PooledUnit.NewUnit.BloodUnitMedia.AboRh.AboRHText;
			this.toolTip1.SetToolTip(this.txtTargetABORh, this._bumControl.PooledUnit.NewUnit.BloodUnitMedia.AboRh.AboRHTextExpanded);

			this.dtpTargetExpirationDate.Value = this._bumControl.PooledUnit.NewUnit.BloodUnitMedia.UnitExpirationDate;

			this.txtTargetDonationType.Text = this._bumControl.PooledUnit.NewUnit.DonationType.DonationTypeText;
			this.updTargetVolume.Value = this._bumControl.PooledUnit.NewUnit.OriginalVolume;
			

			this.txtTargetRestrictedName.Text = this._bumControl.PooledUnit.NewUnit.DirectedPatient.DisplayName;
			this.txtTargetRestrictedSSN.Text = this._bumControl.PooledUnit.NewUnit.DirectedPatient.DisplayPatientID;//SSN;
			this.txtTargetRestrictedStatus.Text = BOL.TestingStatus.GetTestingStatusTextFromID(this._bumControl.PooledUnit.NewUnit.BloodUnitMedia.TestingStatusId);
			this.picTargetBiohazard.Visible = this._bumControl.PooledUnit.NewUnit.BloodUnitStatus.BiohazardousWarningIndicator;
			
			this.txtTargetUnitStatus.Text = this._bumControl.PooledUnit.NewUnit.BloodUnitStatus.UnitStatusDescriptiveText;

			this.cbTargetCMVNeg.Checked			= this._bumControl.TargetCmvNeg;
			//Antigens & SickleCell do not apply to pooled units (cuz of RBc) - says      
			this.cbTargetSickleCellNeg.Checked	= false;
			this.lvTargetAntigens.Items.Clear();
			GUI.controls.VbecsFunction.SetColumnWidths(this.lvTargetAntigens);
	
			this.PopulateContainer();
			this.PopulateEquipment();
			this.PopulateSCDWafer();
			this.PopulateSupplies();
		}


		/// <summary>
		/// Populates the Equipment listview from the pooledunits's EquipmentList property
		/// </summary>
		private void PopulateEquipment()
		{
			int nCount = 0;
			this.lvEquipment.Items.Clear();
			
			if (this._bumControl.PooledUnit.EquipmentList.Count > 0)
			{
				nCount = this._bumControl.PooledUnit.EquipmentList.Count;
				for(int ndx=0; ndx < nCount; ndx++)
				{
					ListViewItem lvi = new ListViewItem();
					BOL.Equipment equip = (BOL.Equipment)this._bumControl.PooledUnit.EquipmentList[ndx];
					
					lvi.Tag = equip;
					lvi.Checked = true;
					lvi.SubItems.Add(equip.SerialNumber);
					lvi.SubItems.Add(equip.EquipmentName);
					lvi.SubItems.Add(equip.ManufacturerName);
					lvi.SubItems.Add(equip.LocalIdentifier);
					
					this.lvEquipment.Items.Add(lvi);
				}
			}

			GUI.controls.VbecsFunction.SetColumnWidths(this.lvEquipment);
		}

		
		/// <summary>
		/// SCD Wafer is some kinda supply thing that's required? when you perform a SCD modification
		/// </summary>
		private void PopulateSCDWafer()
		{
			this.lvSCDWafer.Items.Clear();
			
			if (this._bumControl.PooledUnit.SCDWafer.LotNumber != string.Empty)
			{
			
				ListViewItem lvi = new ListViewItem();

				lvi.Text =  this._bumControl.PooledUnit.SCDWafer.LotNumber;
				lvi.SubItems.Add(this._bumControl.PooledUnit.SCDWafer.SupplyName);
				lvi.SubItems.Add(this._bumControl.PooledUnit.SCDWafer.ManufacturerName);
				lvi.SubItems.Add(Common.VBECSDateTime.FormatDateString(this._bumControl.PooledUnit.SCDWafer.LotExpirationDate));
				
				this.lvSCDWafer.Items.Add(lvi);
			}

			GUI.controls.VbecsFunction.SetColumnWidths(this.lvSCDWafer);
		}


		/// <summary>
		/// Loads the container for the pooledunit
		/// </summary>
		private void PopulateContainer()
		{
			this.lvContainer.Items.Clear();
			
			if (this._bumControl.PooledUnit.Container.LotNumber != string.Empty)
			{
				ListViewItem lvi = new ListViewItem();

				lvi.Text = this._bumControl.PooledUnit.Container.LotNumber;
				lvi.SubItems.Add(this._bumControl.PooledUnit.Container.SupplyName);
				lvi.SubItems.Add(this._bumControl.PooledUnit.Container.ManufacturerName);
				lvi.SubItems.Add(Common.VBECSDateTime.FormatDateString(this._bumControl.PooledUnit.Container.LotExpirationDate));
				
				this.lvContainer.Items.Add(lvi);
			}

			GUI.controls.VbecsFunction.SetColumnWidths(this.lvContainer);
		}


		/// <summary>
		/// Populates the Supply listview from the pooledunits's SupplyList property
		/// </summary>
		private void PopulateSupplies()
		{
			this.lvSupplies.Items.Clear();
			int nCount = 0;
			if (this._bumControl.PooledUnit.SupplyList.Count > 0)
			{
				nCount = this._bumControl.PooledUnit.SupplyList.Count;
				for(int ndx=0; ndx < nCount; ndx++)
				{
					ListViewItem lvi = new ListViewItem();
					BOL.Supply supply = (BOL.Supply)this._bumControl.PooledUnit.SupplyList[ndx];

					lvi.Tag = supply;
					lvi.Checked = true;
					lvi.SubItems.Add(supply.LotNumber);
					lvi.SubItems.Add(supply.SupplyName);
					lvi.SubItems.Add(supply.ManufacturerName);
					lvi.SubItems.Add(Common.VBECSDateTime.FormatDateString(supply.LotExpirationDate));
					
					this.lvSupplies.Items.Add(lvi);
				}
			}

			GUI.controls.VbecsFunction.SetColumnWidths(this.lvSupplies);
		}

		#endregion

		#region Events

		/// <summary>
		/// Refreshes the ExpirationDate - attached to weldindicatorchange event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void RefreshExpirationDate(object sender, System.EventArgs e)
		{
			this._isLoading = true;
			this.dtpTargetExpirationDate.Value = this._bumControl.PooledUnit.NewUnit.BloodUnitMedia.UnitExpirationDate;
			this._bumControl.PooledUnit.TargetBloodProduct = null;
			this.PopulateTargetProductSelection();
			this._isLoading = false;
		}

		/// <summary>
		/// Fires when properties are set on any of our parent/child objects
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ObjectValidityChange(object sender, System.EventArgs e)
		{
			string unitIdErr = this.errError.GetError(this.txtTargetUnitId);
			string tooltipMsg = this._bumControl.GetBrokenRulesMessage(this.Name);
			tooltipMsg = Common.Utility.SumBrokenRulesMessages(tooltipMsg, unitIdErr);

			if (tooltipMsg == string.Empty)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
				this.btnOK.EnabledButton = true;
			}
			else
			{
				this.btnOK.SetToolTip(tooltipMsg);
				this.btnOK.EnabledButton = false;
			}

			this.SetDirtyFlag(this,System.EventArgs.Empty);
		}

		#endregion

		#region Events/Event Handlers


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// OK button click event handler. Prompts user to print and verify label, and prompts to save changes
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			try
			{
				ArrayList labelMismatchExceptions = new ArrayList();
				System.Guid unitGuid = System.Guid.Empty;
				string modification = Common.Utility.GetProductModificationTextFromEnum(this._bumControl.ProductModificationCode);

				if (this._bumControl.ProductModificationCode != Common.ProductModification.EditPool)
				{
					//Check for Uniqueness of the UnitID/ProductCode that they've entered. (BR_1.40), CR 2587
					if (BOL.BloodUnit.BloodUnitExists(this._bumControl.PooledUnit.NewUnit.EyeReadableUnitId, this._bumControl.PooledUnit.NewUnit.BloodProductGuid, this._bumControl.PooledUnit.NewUnit.FullProductCode, ref unitGuid))
					{
						this._bumControl.InactivatePoolCounter();
						if (this._bumControl.PooledUnit.NewUnit.BarcodeType == Common.BarcodeType.Codabar)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC001.BR40UnitAlreadyExists(this._bumControl.PooledUnit.NewUnit.EyeReadableUnitId, this._bumControl.PooledUnit.NewUnit.FullProductCode));
							this.txtTargetUnitId.Focus();
						}
						else
						{
                            string existingId = this._bumControl.PooledUnit.NewUnit.EyeReadableUnitId;      //CR3404b
							string newUnitId = this._bumControl.GetNewPoolId(this.LockController);
							try
							{
								//07/25/2005
								this._bumControl.PooledUnit.NewUnit.SetEyeReadableUnitId(newUnitId, false);
								//CR1993 - Set the LabelUnitId as well as EyeReadableUnitId, since LabelUnitId is used on the label face
								this._bumControl.PooledUnit.NewUnit.SetLabelUnitId(newUnitId, false);
							    this.txtTargetUnitId.Text = newUnitId;      //CR3404b
								this.errError.SetVbecsError(this.txtTargetUnitId, string.Empty); // **** 508 Compliance ***
							}
							catch(BOL.BusinessObjectException err)
							{
								this.errError.SetVbecsError(this.txtTargetUnitId, err.Message); // **** 508 Compliance ***
							}
                            GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC024.BR12PooledIdExists(existingId, this._bumControl.PooledUnit.NewUnit.ProductType.ProductTypeText, newUnitId));															
						}
						return;
					}
				}

				//BR_26.25, BR_24.07
				if (this._bumControl.DoPoolingUnitsHaveAssignedPatients)
				{
					DlgModifyAssignments dlgPatientAssignments = new DlgModifyAssignments(this._bumControl.PoolingUnits);

					dlgPatientAssignments.ShowDialogFromLockedParent(this,false);
					if (dlgPatientAssignments.DialogResult == DialogResult.Abort) return;

                    if (dlgPatientAssignments.DialogResult == DialogResult.OK)
					{
						this._bumControl.InheritedPatientAssignment = dlgPatientAssignments.SelectedPatientAssignment;
					}
				}

				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ReadyToVerifyLabeling(modification), MessageBoxDefaultButton.Button2) == DialogResult.Yes)
				{
					DlgVerifyModifiedUnit dlg = new DlgVerifyModifiedUnit(this._bumControl.PooledUnit, this._bumControl, 0);

					FormWindowState currentState = this.WindowState;
					this.WindowState = FormWindowState.Minimized;

				
					dlg.ShowDialogFromLockedParent(this,false);
                    if (dlg.DialogResult  == DialogResult.Abort) return;

                    if (dlg.DialogResult == DialogResult.OK)
					{
						this._bumControl.PooledUnit.NewLabelVerificationDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					}

					this._bumControl.PooledUnit.LabelVerificationFailed = (dlg.LabelMismatchExceptions.Count > 0);
					this.WindowState = currentState;
					this._bumControl.LabelExceptions = dlg.LabelMismatchExceptions;
				}

				DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave(modification));
			
				if (_saveResult == DialogResult.Yes)
				{
					if (this._bumControl.Save(Common.UpdateFunction.UC024FrmPoolUnits))
					{
						this.IsDirty = false;
						this.Close();
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved(modification));
						return;
					}	
					//CR 1441  -- BloodUnitModification.WorkladCode will check BaseProductModficiationCode for the correct value for pools
					System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int)this._bumControl.WorkloadCode);	
						
					if(dt!= null)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
				}
			}
			catch(Common.RowVersionException)
			{
				this.btnOK.RowVersionException = true;		//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
			}
			
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Cancel button click event handler, closes form
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Original unit tab control index changed event handler, loads selected parent unit into UI controls
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void tabOriginal_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this._currentPoolingUnit = (BOL.BloodUnit)this._bumControl.PoolingUnits[this.tabOriginal.SelectedIndex];
			this.PopulateSourceDetails();
			base.ResetLockTimer(this, System.EventArgs.Empty);
		}


		/// <summary>
		/// This makes the original and target tiny little "extra info" tabs switch at the same time
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ExtraInfoTabsClicked(object sender, System.EventArgs e)
		{
			if (sender == this.tabOriginalExtraInfo)
			{
				this.tabTargetExtraInfo.SelectedIndex = this.tabOriginalExtraInfo.SelectedIndex;
			}
			else if (sender == this.tabTargetExtraInfo)
			{
				this.tabOriginalExtraInfo.SelectedIndex = this.tabTargetExtraInfo.SelectedIndex;
			}
			base.ResetLockTimer(this, System.EventArgs.Empty);
		}

		private void rdoComplete_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.rdoComplete.Checked)
					this._bumControl.NewContainerWeldIndicator = true;
			}
		}

		private void rdoIncomplete_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.rdoIncomplete.Checked)
					this._bumControl.NewContainerWeldIndicator = false;
			}
		}

		/// <summary>
		/// Handles the manual entry of UnitExpirationDate
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpTargetExpirationDate_Leave(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.dtpTargetExpirationDate.Value == this._bumControl.PooledUnit.UnitExpirationDate)
					return;

				//BR_26.21 - check the target's expiraton date
				if (this.dtpTargetExpirationDate.Value > this._bumControl.PooledUnit.RecommendedExpirationDateTime(this._bumControl))
				{
					if (ThisUser.CurrentDivisionRole.Role.UserRoleId >= Common.UserRoleType.EnhancedTechnologist)
					{
						if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.IssueExpiredBloodProducts))
						{
							DlgExpiredUnitConfirm dlgExpire = new DlgExpiredUnitConfirm(this._bumControl.PooledUnit.NewUnit, Common.StrRes.ValidMsg.UC026.BR21TargetDateRange(this._bumControl.PooledUnit.NewUnit.EyeReadableUnitId, this._bumControl.PooledUnit.NewUnit.ProductType.ProductTypeText).ResString);

							dlgExpire.ShowDialogFromLockedParent(this,false);
                            if (dlgExpire.DialogResult == DialogResult.Abort) return;

                            if (dlgExpire.DialogResult == DialogResult.OK)
							{
								this._bumControl.PooledUnit.UnitExpirationDate = this.dtpTargetExpirationDate.Value;
								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Target_product_outdate_extended, dlgExpire.Comment, Common.LogonUser.LogonUserName);
								exRep.GenerateExceptionUnitModification(this._bumControl.PooledUnit.NewUnit, this._bumControl, this._bumControl.PooledUnit.RecommendedExpirationDateTime(this._bumControl), null);
								this._bumControl.Exceptions.Add(exRep);
							}
							else
							{
								//Since we're not disabling the OK button (nor changing the Objects value
								//Let the user see what's actually being saved
								this.dtpTargetExpirationDate.Value = this._bumControl.PooledUnit.RecommendedExpirationDateTime(this._bumControl);
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
						}
					}
					else
					{
						//BR_26.28 - Security Level 1 check
						GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR28ExpirationDateOutOfRange(this._bumControl.PooledUnit.NewUnit.EyeReadableUnitId, this._bumControl.PooledUnit.NewUnit.ProductType.ProductTypeText));
						this.dtpTargetExpirationDate.Value = this._bumControl.PooledUnit.UnitExpirationDate;
					}
				}
				else
				{
					this._bumControl.PooledUnit.UnitExpirationDate = this.dtpTargetExpirationDate.Value;
				}
			}
		}


		/// <summary>
		/// Brings up DlgSelectSupply
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddContainer_Click(object sender, System.EventArgs e)
		{
			ArrayList usedSupplies = new ArrayList();
			usedSupplies.Add(this._bumControl.PooledUnit.Container);

			DlgSelectSupply dlg = new DlgSelectSupply(Common.SupplyType.Containers, false, usedSupplies, this._currentPoolingUnit, this._bumControl);

			dlg.ShowDialogFromLockedParent(this,false);

			if (dlg.DialogResult == DialogResult.OK)
			{
				this._bumControl.PooledUnit.Container = (BOL.Supply)dlg.SelectedSupplyList[0];
				this.PopulateContainer();
			}
		}


		/// <summary>
		/// Brings up DlgSelectEquipment
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddEquipment_Click(object sender, System.EventArgs e)
		{
			DlgSelectEquipment dlg = new DlgSelectEquipment(this._bumControl.PooledUnit.EquipmentList, this._bumControl);

			dlg.ShowDialogFromLockedParent(this,false);

			if (dlg.DialogResult == DialogResult.OK)
			{
				this._bumControl.PooledUnit.EquipmentList = dlg.SelectedEquipmentList;
				this.PopulateEquipment();
			}
		}


		/// <summary>
		/// Brings up DlgSelectSupply
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddSupplies_Click(object sender, System.EventArgs e)
		{
			DlgSelectSupply dlg = new DlgSelectSupply(Common.SupplyType.AllSupplies, true, this._bumControl.PooledUnit.SupplyList, this._currentPoolingUnit, this._bumControl);

			dlg.ShowDialogFromLockedParent(this,false);

			if (dlg.DialogResult == DialogResult.OK)
			{
				this._bumControl.PooledUnit.SupplyList = dlg.SelectedSupplyList;
				this.PopulateSupplies();
			}
		}


		/// <summary>
		/// Brings up DlgSelectSupply
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddWafer_Click(object sender, System.EventArgs e)
		{
			ArrayList usedSupplies = new ArrayList();
			usedSupplies.Add(this._bumControl.PooledUnit.SCDWafer);

			DlgSelectSupply dlg = new DlgSelectSupply(Common.SupplyType.SCDWafer, false, usedSupplies, this._currentPoolingUnit, this._bumControl);

			dlg.ShowDialogFromLockedParent(this,false);

			if (dlg.DialogResult == DialogResult.OK)
			{
				this._bumControl.PooledUnit.SCDWafer = (BOL.Supply)dlg.SelectedSupplyList[0];
				this.PopulateSCDWafer();
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Pooled unit volume control change event, sets volume property of pooled unit
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void updTargetVolume_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					if (this._bumControl.PooledUnit.NewUnit.OriginalVolume == this.updTargetVolume.Value)
						return;

					this._bumControl.PooledUnit.NewUnit.OriginalVolume = this.updTargetVolume.Value;

					this.errError.SetVbecsError(this.updTargetVolume, string.Empty); // **** 508 Compliance ***
				}
				catch(Exception err) 
				{
					this.errError.SetVbecsError(this.updTargetVolume, err.Message); // **** 508 Compliance ***
					//This breaks the BrokenRule
					this._bumControl.PooledUnit.NewUnit.OriginalVolume = decimal.MinusOne;
				}
			}
		}

		private void updTargetVolume_Leave(object sender, System.EventArgs e)
		{
			try
			{
				this._isLoading = true;
				this.updTargetVolume.Value = this.updTargetVolume.Value;
				this._bumControl.PooledUnit.NewUnit.OriginalVolume = this.updTargetVolume.Value;
				this.errError.SetVbecsError(this.updTargetVolume, string.Empty); // **** 508 Compliance ***
			}
			catch(Exception err)
			{
				this._bumControl.PooledUnit.NewUnit.OriginalVolume = decimal.MinusOne;
				this.errError.SetVbecsError(this.updTargetVolume, err.Message); // **** 508 Compliance ***
			}
			this._isLoading = false;
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Pooled unit product name combo box changed event handler, sets target blood product properties
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbTargetProductName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				bool cont = true;
				System.Guid unitGuid = System.Guid.Empty;

				if (this._isLoading  || this.cmbTargetProductName.SelectedIndex == -1)
					return;

				BOL.BloodProduct tmpProduct = new BOL.BloodProduct((System.Guid)((System.Data.DataRow)this._targetProductList[cmbTargetProductName.SelectedIndex])[TABLES.BloodProduct.BloodProductGuid]);
							
				//BR_26.11 - check target product type is active
				if ( !BOL.BloodProduct.IsBloodProductActive(tmpProduct.BloodProductGuid) || !tmpProduct.IsProductShipperActive(this._bumControl.PooledUnit.NewUnit.IncomingShipment.LocalSupplierGuid))
				{
					//BR_26.11 - if the product isn't active, bring up UC8 to make it so
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.ProductNotActive(tmpProduct.ProductShortName));

					if( !ActivateBloodProduct( 
						tmpProduct.BloodProductGuid, 
						this._bumControl.PooledUnit.NewUnit.IncomingShipment.LocalSupplier, 
						(this._bumControl.PooledUnit.NewUnit.BarcodeType == Common.BarcodeType.Codabar) ) )
					{
						//If it's not OK, they clicked cancel or problem occurred
						//According to BR_26.11 - let them pick another??
						cont = false;
						this.cmbTargetProductName.SelectedIndex = -1;
                        this._bumControl.PooledUnit.TargetBloodProduct = null;      //CR3311 - quicky slippy
					}										
				}

				if (cont)
				{

					//For regular pools, we have to validate to make sure that the unit ID doesn't exist
					if (this._bumControl.ProductModificationCode != Common.ProductModification.EditPool)
					{
						//Check for Uniqueness of the UnitID/ProductCode that they've entered. (BR_1.40) CR 2587
						if (BOL.BloodUnit.BloodUnitExists(this._bumControl.PooledUnit.NewUnit.EyeReadableUnitId, this._bumControl.PooledUnit.NewUnit.BloodProductGuid, this._bumControl.PooledUnit.NewUnit.FullProductCode, ref unitGuid))
						{
							this._bumControl.InactivatePoolCounter();
							if (this._bumControl.PooledUnit.NewUnit.BarcodeType == Common.BarcodeType.Codabar)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC001.BR40UnitAlreadyExists(this._bumControl.PooledUnit.NewUnit.EyeReadableUnitId, this._bumControl.PooledUnit.NewUnit.FullProductCode));
								this.txtTargetUnitId.Focus();
								string err = this.errError.GetError(this.txtTargetUnitId);
								if (err == string.Empty)
								{
									this.errError.SetVbecsError(this.txtTargetUnitId, "Duplicate Unit Id and product code."); // **** 508 Compliance ***
								}
							}
							else
							{
								string newUnitId = this._bumControl.GetNewPoolId(this.LockController);
								try
								{
									//07/25/2005
									this._bumControl.PooledUnit.NewUnit.SetEyeReadableUnitId(newUnitId, false);
									//CR1993 - Set the LabelUnitId as well as EyeReadableUnitId, since LabelUnitId is used 
									//on the label face
									this._bumControl.PooledUnit.NewUnit.SetLabelUnitId(newUnitId, false);
									this.errError.SetVbecsError(this.txtTargetUnitId, string.Empty); // **** 508 Compliance ***
								}
								catch(BOL.BusinessObjectException err)
								{
									this.errError.SetVbecsError(this.txtTargetUnitId, err.Message); // **** 508 Compliance ***
								}
								GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC024.BR12PooledIdExists(this._bumControl.PooledUnit.NewUnit.EyeReadableUnitId, this._bumControl.PooledUnit.NewUnit.ProductType.ProductTypeText, newUnitId));															
							}

							this._isLoading = true;
                            this._bumControl.PooledUnit.TargetBloodProduct = null;      //CR3311 - quicky slippy
							this.cmbTargetProductName.SelectedIndex = -1;
							this._isLoading = false;
							
							return;
						}
					}

					//Putting the BloodProductSet down here will re-validate the EyeReadable/ProductCode combo so the user
					//doesn't have to wait until btnOK_Click
					this._bumControl.PooledUnit.TargetBloodProduct = tmpProduct;

					this.toolTip1.SetToolTip(this.cmbTargetProductName, this._bumControl.PooledUnit.TargetBloodProduct.ProductName);
					this.errError.SetVbecsError(this.cmbTargetProductName, string.Empty); // **** 508 Compliance ***
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.cmbTargetProductName, err.Message); // **** 508 Compliance ***
			}	
		}

		private bool ActivateBloodProduct( Guid bloodProductGuid, BOL.LocalSupplier localSupplier, bool isCodabar )
		{
			if( DAL.VAL.VistALink.EnsureAvailability() )
			{
				if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.ActivateEditBloodProductInformation))
				{
					FrmBloodProductEdit frmBPEdit = new FrmBloodProductEdit( bloodProductGuid, localSupplier, isCodabar);

                    //Abort means the lock failed
					if (frmBPEdit.DialogResult != DialogResult.Abort)
					{
                        frmBPEdit.ShowDialogFromLockedParent(this, true);
                        return (frmBPEdit.DialogResult == DialogResult.OK);
					}
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("edit blood product information"));
				}
			}

			return false;		
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/31/2003</CreationDate>
		///
		/// <summary>
		/// Target Unit ID tetx box leave event, checks uniqueness of unit ID and product code
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtTargetUnitId_Leave(object sender, System.EventArgs e)
		{
			try
			{
				//07/25/2005
				Regex labelUnitIdEx = Common.RegularExpressions.PooledCodabarEyeReadableUnitId();
				if (!labelUnitIdEx.IsMatch(this.txtTargetUnitId.Text))
				{
					throw new BOL.BusinessObjectException("Unit Id is invalid.");
				}

				this._bumControl.PooledUnit.NewUnit.SetEyeReadableUnitId(this.txtTargetUnitId.Text, false);
				//CR1993 - Set the LabelUnitId as well as EyeReadableUnitId, since LabelUnitId is used 
				//on the label face
				this._bumControl.PooledUnit.NewUnit.SetLabelUnitId(this.txtTargetUnitId.Text, false);
				this.errError.SetVbecsError(this.txtTargetUnitId, string.Empty); // **** 508 Compliance ***
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.txtTargetUnitId, err.Message); // **** 508 Compliance ***
			}
			finally
			{
				this.ObjectValidityChange(this, System.EventArgs.Empty);
			}

		}

		private void lvSupplies_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 4)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvSupplies.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvSupplies.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void lvSupplies_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			BOL.Supply trgSupply = (BOL.Supply)this.lvSupplies.Items[e.Index].Tag;
			int foundNdx = -1;

			for (int ndx=0; ndx < this._bumControl.PooledUnit.SupplyList.Count; ndx++)
			{
				BOL.Supply srcSupply = (BOL.Supply)this._bumControl.PooledUnit.SupplyList[ndx];

				if (srcSupply.SupplyGuid == trgSupply.SupplyGuid)
				{
					foundNdx = ndx;
					break;
				}
			}

			if (e.NewValue == System.Windows.Forms.CheckState.Checked)
			{
				if (foundNdx == -1)	//If they're checking and it doesn't already exist...add it
					this._bumControl.PooledUnit.SupplyList.Add(trgSupply);
			}
			else
			{
				if (foundNdx > -1)	//They're unchecking and it's inside the list.... remove it
					this._bumControl.PooledUnit.SupplyList.RemoveAt(foundNdx);
			}
		}

		private void lvEquipment_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			BOL.Equipment trgEquip = (BOL.Equipment)this.lvEquipment.Items[e.Index].Tag;
			int foundNdx = -1;

			for (int ndx=0; ndx < this._bumControl.PooledUnit.EquipmentList.Count; ndx++)
			{
				BOL.Equipment srcEquip = (BOL.Equipment)this._bumControl.PooledUnit.EquipmentList[ndx];

				if (srcEquip.EquipmentGuid == trgEquip.EquipmentGuid)
				{
					foundNdx = ndx;
					break;
				}
			}

			if (e.NewValue == System.Windows.Forms.CheckState.Checked)
			{
				if (foundNdx == -1)	//If they're checking and it doesn't already exist...add it
					this._bumControl.PooledUnit.EquipmentList.Add(trgEquip);
			}
			else
			{
				if (foundNdx > -1)	//They're unchecking and it's inside the list.... remove it
					this._bumControl.PooledUnit.EquipmentList.RemoveAt(foundNdx);
			}

		}

		private void lvEquipment_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvEquipment.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
		}

		private void tabSuppliesEquipment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			base.ResetLockTimer(this, System.EventArgs.Empty);
		}

		private void dtpTargetExpirationDate_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			base.ResetLockTimer(this, System.EventArgs.Empty);
		}

		private void txtTargetUnitId_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			base.ResetLockTimer(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmPoolUnits_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton )
			{
				this.SpeakMessage( this.btnOK.GetToolTip() );
			}
		}

		#endregion

		private void txtTargetRestrictedStatus_TextChanged(object sender, System.EventArgs e)
		{
		
		}

		private void FrmPoolUnits_Load(object sender, System.EventArgs e)
		{
			this.txtNumberOfUnits.Focus();
		}
	}
}

